package com.supwisdom.dlpay.framework.util;

import java.text.DecimalFormat;

public class MoneyUtil {

  public static int YuanToFen(double yuan) {
    return (int) (Math.round(yuan * 100));
  }

  public static boolean moneyEqual(double x1, double x2) {
    return YuanToFen(x1) == YuanToFen(x2);
  }

  public static int moneyCompare(double x1, double x2) {
    return YuanToFen(x1) - YuanToFen(x2);
  }

  public static double formatYuan(double yuan) {
    DecimalFormat df = new DecimalFormat("##0.00");
    double money = ((double) YuanToFen(yuan)) / 100;
    return Double.valueOf(df.format(money));
  }

  public static String formatYuanToString(Double yuan) {
    if (null == yuan) return "0.00";
    DecimalFormat df = new DecimalFormat("##0.00");
    double money = ((double) YuanToFen(yuan)) / 100;
    return df.format(money);
  }
  public static double FenToYuan(int fen) {
    return formatYuan(fen / 100.0);
  }

}
