package com.supwisdom.dlpay.framework.util;

import com.supwisdom.dlpay.framework.service.BusinessparaService;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

@Component
public class ShortURLUtil {

    @Autowired
    private BusinessparaService businessparaService;

    private static final Logger logger = LoggerFactory.getLogger(ShortURLUtil.class);

    public String doGetShortUrl(String longUrl) {
        return doGetBaiduShortUrl(longUrl);
    }

    public String doGetBaiduShortUrl(String longUrl) {
        String shortUrlService = businessparaService.findByParakey(WaterBudinessConstants.WATER_SHORTURL_BAIDU).getParaval(); //https://dwz.cn/admin/v2/create
        String baiduToken = businessparaService.findByParakey(WaterBudinessConstants.WATER_SHORTURL_BAIDU_TOKEN).getParaval(); //由数字和字母组成的32位字符,注册申请
        if (StringUtil.isEmpty(shortUrlService) || StringUtil.isEmpty(baiduToken)) {
            logger.error("百度水控短地址生成服务器参数未配置！");
            return null;
        }

        String termOfValidity = "1-year";
        String params = "{\"Url\":\"" + longUrl + "\",\"TermOfValidity\":\"" + termOfValidity + "\"}";

        BufferedReader reader = null;
        try {
            // 创建连接
            URL url = new URL(shortUrlService);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("POST"); // 设置请求方式
            connection.setRequestProperty("Content-Type", "application/json"); // 设置发送数据的格式
            connection.setRequestProperty("Token", baiduToken); // 设置发送数据的格式");
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(3000);

            // 发起请求
            connection.connect();
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8"); // utf-8编码
            out.append(params);
            out.flush();
            out.close();

            // 读取响应
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            String line;
            String result = "";
            while ((line = reader.readLine()) != null) {
                result += line;
            }
            reader.close();
            //      {
            //          "Code": 0,
            //          "ShortUrl": "https://dwz.cn/de3rp2Fl",
            //          "LongUrl": "http://www.baidu.com",
            //          "ErrMsg": ""
            //      }
            logger.info("Baidu shortUrl origin LongUrl=[" + longUrl + "], return=[" + result + "]");
            if (StringUtil.isEmpty(result)) {
                logger.error("百度短网址返回为空！！！");
                return null;
            }
            JSONObject json = JSONObject.fromObject(result);
            if (json.has("Code") && json.getInt("Code") == 0) {
                logger.info("百度短地址生成成功！LongUrl=[" + longUrl + "],ShortUrl=[" + json.getString("ShortUrl") + "]");
                return json.getString("ShortUrl");
            } else {
                logger.error("短地址生成失败！！！" + json.getString("ErrMsg"));
                return null;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        } finally {
            try {
                if (null != reader) {
                    reader.close();
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*private String doGetSinaShortUrl(String longUrl) {
        String result = "";
        BufferedReader in = null;
        try {
            String address = businessparaService.findByParakey(WaterBudinessConstants.waterSinaShortUrl).getParaval();
            address += "&url_long=" + URLEncoder.encode(longUrl, "UTF-8");
            URL url = new URL(address);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5 * 1000);
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line;
            while ((line = in.readLine()) != null) {
                result += line;
            }
            //[{"url_short":"http://t.cn/Ai0aAb8p","url_long":"http://172.28.43.20:8080/water/api/confirm?refno=11","type":0}]
            result = result.substring(1, result.length() - 1);
            JSONObject json = JSONObject.fromObject(result);
            if (json.getInt("type") != 0) {
//                logger.error("[" + longUrl + "]短地址生成错误：" + json.getString("rs_msg"));
                return null;
            }
            return json.getString("url_short");
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        } finally {
            try {
                if (null != in) in.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }*/
}
