package com.supwisdom.dlpay.system.controller;

import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.system.service.DictionaryProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import java.util.Map;

@RestController
public class DictPoolAction {
  @Autowired
  private DictionaryProxy dictionaryProxy;

  @GetMapping("/dictpool")
  public Map getDictDataByDicttype(@FormParam("dicttype") String dictType, HttpServletRequest request) {
    dictType = request.getParameter("dicttype");
    return dictionaryProxy.getDictionaryAsMap(dictType);
  }

  @GetMapping("/dictrefresh")
  public JsonResult refreshDict() {
    return JsonResult.ok();
  }

}
