package com.supwisdom.dlpay.system.controller;

import com.supwisdom.dlpay.api.domain.TPersondtl;
import com.supwisdom.dlpay.api.domain.TShopdtl;
import com.supwisdom.dlpay.api.domain.TSourceType;
import com.supwisdom.dlpay.framework.domain.TDictionary;
import com.supwisdom.dlpay.framework.util.Dictionary;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.WebConstant;
import com.supwisdom.dlpay.system.bean.ShopdtlSearchBean;
import com.supwisdom.dlpay.system.bean.TreeSelectNode;
import com.supwisdom.dlpay.system.bean.UserdtlSearchBean;
import com.supwisdom.dlpay.system.service.DictionaryProxy;
import com.supwisdom.dlpay.system.service.DtlDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

@Controller
public class DtlController {
  @Autowired
  private DtlDataService dtlDataService;

  @Autowired
  private DictionaryProxy dictionaryProxy;

  /**
   * ====================================================
   * 个人流水查询
   * ====================================================
   */

  @GetMapping("/dtl/userdtllist")
  @PreAuthorize("hasPermission('/dtl/userdtl','')")
  @ResponseBody
  public PageResult<TPersondtl> searchUserdtlPage(@ModelAttribute UserdtlSearchBean searchBean) {
    try {
      Integer pageNo = searchBean.getPage();
      Integer pageSize = searchBean.getLimit();
      if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
      if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
      return dtlDataService.getPersondtlPage(searchBean, pageNo, pageSize);
    } catch (Exception e) {
      e.printStackTrace();
      return new PageResult<>(99, "系统查询错误");
    }
  }

  /**
   * ====================================================
   * 商户流水查询
   * ====================================================
   */
  @GetMapping("/dtl/shopdtl")
  public String shopdtlView(Model model) {
    model.addAttribute(Dictionary.PAY_TYPE,
        dictionaryProxy.getDictionaryAsList(Dictionary.SOURCE_TYPE));
    model.addAttribute(Dictionary.TRANS_CODE,
        dictionaryProxy.getDictionaryAsList(Dictionary.TRANS_CODE));
    model.addAttribute(Dictionary.DTL_STATUS,
        dictionaryProxy.getDictionaryAsList(Dictionary.DTL_STATUS));
    return "system/dtl/shopdtl";
  }

  @GetMapping("/dtl/shopdtllist")
  @PreAuthorize("hasPermission('/dtl/shopdtl','')")
  @ResponseBody
  public PageResult<TShopdtl> searchUserdtlPage(@ModelAttribute ShopdtlSearchBean searchBean) {
    try {
      Integer pageNo = searchBean.getPage();
      Integer pageSize = searchBean.getLimit();
      if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
      if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
      return dtlDataService.getShopdtlPage(searchBean, pageNo, pageSize);
    } catch (Exception e) {
      e.printStackTrace();
      return new PageResult<>(99, "系统查询错误");
    }
  }


}
