package com.supwisdom.dlpay.system.controller;

import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.framework.domain.TRole;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.WebConstant;
import com.supwisdom.dlpay.system.bean.FunctionSearchBean;
import com.supwisdom.dlpay.system.bean.ZTreeNode;
import com.supwisdom.dlpay.system.service.RoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Controller
public class RoleController {
    @Autowired
    private RoleService roleService;
    @GetMapping("/role/index")
    public String indexView() {
        return "system/role/index";
    }

    @GetMapping("/role/list")
    @PreAuthorize("hasPermission('/role/index','')")
    @ResponseBody
    public PageResult<TRole> getDataList(@RequestParam("page") Integer pageNo,
                                         @RequestParam("limit") Integer pageSize,
                                         @RequestParam(value = "searchkey", required = false) String searchKey) {
        try {
            if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
            if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
            FunctionSearchBean searchBean = new FunctionSearchBean();
            searchBean.setPageNo(pageNo);
            searchBean.setFunctioname(searchKey);
            searchBean.setPageSize(pageSize);
            return roleService.getRolesByKey(searchBean);
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }

    @GetMapping("/role/loadadd")
    public String loadadd() {
        return "system/role/form";
    }

    @PostMapping("/role/add")
    @PreAuthorize("hasPermission('/role/add','')")
    @ResponseBody
    public JsonResult add(@RequestBody TRole role) {
        if (role != null) {
            return roleService.saveRole(role);
        } else {
            return JsonResult.error("添加失败");
        }
    }

    @GetMapping("/role/loadfunc")
    @PreAuthorize("hasPermission('/role/loadfunc','')")
    public String loadfunc() {
        return "system/role/func";
    }

    @PostMapping("/role/addfunc")
    @PreAuthorize("hasPermission('/role/addfunc','')")
    @ResponseBody
    public JsonResult addfunc(@RequestParam String roleId,
                              @RequestParam String funcs) {
        return roleService.saveRoleFuncId(roleId, funcs);
    }

    @GetMapping("/role/func")
    @ResponseBody
    public JsonResult func(@RequestParam String roleId) {
        List<ZTreeNode> nodes = roleService.findByRoleIdNative(roleId);
        JsonResult result = JsonResult.ok();
        result.put("node", nodes);
        return result;
    }
    @PostMapping("/role/del")
    @PreAuthorize("hasPermission('/role/del','')")
    @ResponseBody
    public JsonResult del(@RequestParam String  roleid) {
        return roleService.deleteRole(roleid);
    }
}
