package com.supwisdom.dlpay.system.controller;

import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.api.domain.TShopPaytypeConfig;
import com.supwisdom.dlpay.api.domain.TSourceType;
import com.supwisdom.dlpay.framework.service.SystemUtilService;
import com.supwisdom.dlpay.framework.util.*;
import com.supwisdom.dlpay.system.bean.ShopConfigBean;
import com.supwisdom.dlpay.system.service.DictionaryProxy;
import com.supwisdom.dlpay.system.service.ParamService;
import com.supwisdom.dlpay.system.service.ShopDataService;
import com.supwisdom.dlpay.util.WebCheckException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Controller
public class ShopController {
  @Autowired
  private ShopDataService shopDataService;
  @Autowired
  private ParamService paramService;
  @Autowired
  private SystemUtilService systemUtilService;

  @Autowired
  private DictionaryProxy dictionaryProxy;

  @GetMapping("/shop/index")
  public String shopView() {
    return "system/shop/index";
  }


  /**
   * ====================================================
   * 商户支付能力配置
   * ====================================================
   */
  @GetMapping("/shop/config")
  public String shopConfigView(Model model) {
//    model.addAttribute("paytypelist", shopDataService.getConsumePaytypes());
    model.addAttribute(Dictionary.PAY_TYPE,
        dictionaryProxy.<TSourceType>getDictionaryAsList(Dictionary.SOURCE_TYPE));
    return "system/shop/config";
  }


  @GetMapping("/shop/load4addpaytype")
  @PreAuthorize("hasPermission('/shop/load4addpaytype','')")
  public String load4AddShopPaytype(Model model) {
    model.addAttribute(Dictionary.PAY_TYPE,
        dictionaryProxy.getDictionaryAsList(Dictionary.SOURCE_TYPE));
    return "system/shop/configform";
  }



  @GetMapping("/shop/load4paytypepara")
  @PreAuthorize("hasPermission('/shop/load4paytypepara','')")
  public String load4AddShopPaytypePara(@RequestParam("shopaccno") String shopaccno,
                                        @RequestParam("paytype") String paytype,
                                        Model model) {
    List<TShopPaytypeConfig> configList = shopDataService.getShopPaytypeConfigs(shopaccno, paytype);
    model.addAttribute("configlist", configList);
    model.addAttribute("shopaccno", shopaccno);
    model.addAttribute("paytype", paytype);
    return "system/shop/configpara";
  }


}
