package com.supwisdom.dlpay.system.service;

import com.supwisdom.dlpay.framework.domain.DictionaryTable;
import com.supwisdom.dlpay.framework.util.Dictionary;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class DictionaryProxy {
  private final DictionaryDataService dictionaryDataService;

  private final ParamService paramService;

  public DictionaryProxy(DictionaryDataService dictionaryDataService, ParamService paramService) {
    this.dictionaryDataService = dictionaryDataService;
    this.paramService = paramService;
  }

  @SuppressWarnings("UNCHECKED_CAST")
  public <T> Map<String, T> getDictionaryObject(String dictType) {
    List<T> list = getDictionaryAsList(dictType);
    Map<String, T> result = new HashMap<>();
    for (Object item : list) {
      if (item instanceof DictionaryTable) {
        result.put(((DictionaryTable) item).getDictKey(), (T) item);
      }
    }
    return result;
  }

  public Map<String, Object> getDictionaryAsMap(String dictType) {
    List list = getDictionaryAsList(dictType);
    Map<String, Object> result = new HashMap<>();
    for (Object item : list) {
      if (item instanceof DictionaryTable) {
        DictionaryTable it = (DictionaryTable) item;
        result.put(it.getDictKey(), it.getDictValue());
      }
    }
    return result;
  }

  @SuppressWarnings("UNCHECKED_CAST")
  public <T> List<T> getDictionaryAsList(String dictType) {
      return (List<T>) dictionaryDataService.getDictionaryByDictType(dictType);
  }
}
