package com.supwisdom.dlpay.system.service;

import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.framework.domain.TFunction;
import com.supwisdom.dlpay.framework.domain.TResource;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.system.bean.FunctionSearchBean;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

public interface FunctionService {
  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  List<TFunction> getFunctionsByOperid(String operid);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  List<Map<String, Object>> getMenuTree(List<TFunction> funcList, Integer parentId);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  PageResult<TFunction> getFunctionsByKey(FunctionSearchBean param);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  TFunction getFunctionByNameAndId(String name, Integer id);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  JsonResult saveFunction(TFunction function);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  TFunction getFunctionById(Integer id);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  JsonResult deleteFunction(Integer funcid);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  List<TFunction> getParentFunction();

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  List<TResource> getResources(Integer function);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  List<TFunction> getLeafFunction();

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  JsonResult saveRes(TResource resource);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  JsonResult deleteResource(Integer resid);
}
