package com.supwisdom.dlpay.system.service;

import com.supwisdom.dlpay.api.domain.TPaytypeConfig;
import com.supwisdom.dlpay.api.domain.TSourceType;
import com.supwisdom.dlpay.framework.domain.TApiClient;
import com.supwisdom.dlpay.framework.domain.TBusinesspara;
import com.supwisdom.dlpay.framework.domain.TSyspara;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.util.WebCheckException;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;


public interface ParamService {
  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  PageResult<TSyspara> getSysparaPage(Integer paraid, String paraname, int pageNo, int pageSize);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  TSyspara getSysparaByParaid(int paraid);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  boolean updateSyspara(TSyspara syspara);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  PageResult<TBusinesspara> getBusinessparaPage(String paraname, int pageNo, int pageSize);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  TBusinesspara getBusinessparaByParakey(String parakey);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  boolean deleteBusinesspara(TBusinesspara businesspara);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  PageResult<TApiClient> getApiClientparaPage(String appid, int pageNo, int pageSize);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  TApiClient getApiClientByAppid(String appid);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  boolean saveOrUpdateApiClient(TApiClient apiClient);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  boolean deleteApiClient(TApiClient apiClient);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  PageResult<TSourceType> getSourceTypePage(String paytype, int pageNo, int pageSize);

  @Transactional(readOnly = true)
  List<TSourceType> getAllSourceType();

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  TSourceType getSourceType(String paytype);


  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  boolean deleteSourceType(TSourceType paytype);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  List<TPaytypeConfig> getSourceTypeConfigList(String paytype);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  boolean saveSourceTypeConfig(String paytype, Map<String, String> param) throws WebCheckException;


}
