package com.supwisdom.dlpay.system.service;

import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.system.bean.ShopBusinessShowBean;
import com.supwisdom.dlpay.system.bean.SubjectDayShowBean;
import com.supwisdom.dlpay.system.bean.SubjectDetailShowBean;
import com.supwisdom.dlpay.system.bean.TreeSelectNode;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface SettleReportService {
  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  String getSystemSettledate();

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  PageResult<SubjectDayShowBean> getSubjectDayInfos(String startdate, String enddate, boolean nodealshow);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  PageResult<SubjectDetailShowBean> getSubjectDetailInfos(String startdate, String enddate, String subjno, int pageNo, int pageSize);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  List<TreeSelectNode> getSystemShowSubjectTree();

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  List<TreeSelectNode> getSystemNormalShopTree();

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
  PageResult<ShopBusinessShowBean> getShopBusinessShowInfos(String startdate, String enddate, String shopid, boolean nodealshow);
}
