package com.supwisdom.dlpay.system.service;

import com.supwisdom.dlpay.api.domain.TShopPaytype;
import com.supwisdom.dlpay.api.domain.TShopPaytypeConfig;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.system.bean.ShopConfigBean;
import com.supwisdom.dlpay.system.bean.ZTreeNode;
import com.supwisdom.dlpay.util.WebCheckException;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface ShopDataService {
  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  TShopPaytype getShopPaytype(String shopaccno, String paytype);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  List<TShopPaytypeConfig> getShopPaytypeConfigs(String shopaccno, String paytype);

}
