package com.supwisdom.dlpay.system.service.impl;

import com.supwisdom.dlpay.framework.dao.DictionaryDao;
import com.supwisdom.dlpay.framework.domain.TDictionary;
import com.supwisdom.dlpay.system.service.DictionaryDataService;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class DictionaryDataServiceImpl implements DictionaryDataService {
  private final DictionaryDao dictionaryDao;

  public DictionaryDataServiceImpl(DictionaryDao dictionaryDao) {
    this.dictionaryDao = dictionaryDao;

  }

  @Override
  @Cacheable(cacheNames = "dicationary_cache", key = "#p0")
  public List<TDictionary> getDictionaryByDictType(String dicttype) {
    List<TDictionary> list = dictionaryDao.findAllByDicttype(dicttype);
    if (!list.isEmpty()) {
      return list;
    }
    return new ArrayList<>();
  }

}
