package com.supwisdom.dlpay.system.service.impl;

import com.supwisdom.dlpay.api.dao.PaytypeConfigDao;
import com.supwisdom.dlpay.api.dao.ShopPaytypeConfigDao;
import com.supwisdom.dlpay.api.dao.ShopPaytypeDao;
import com.supwisdom.dlpay.api.dao.SourceTypeDao;
import com.supwisdom.dlpay.api.domain.TPaytypeConfig;
import com.supwisdom.dlpay.api.domain.TShopPaytype;
import com.supwisdom.dlpay.api.domain.TShopPaytypeConfig;
import com.supwisdom.dlpay.api.domain.TSourceType;
import com.supwisdom.dlpay.framework.data.SystemDateTime;
import com.supwisdom.dlpay.framework.service.SystemUtilService;
import com.supwisdom.dlpay.framework.tenant.TenantContext;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.framework.util.Subject;
import com.supwisdom.dlpay.framework.util.TradeDict;
import com.supwisdom.dlpay.system.bean.ShopConfigBean;
import com.supwisdom.dlpay.system.bean.ZTreeNode;
import com.supwisdom.dlpay.system.service.ShopDataService;
import com.supwisdom.dlpay.util.WebCheckException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;

@Service
public class ShopDataServiceImpl implements ShopDataService {
  @Autowired
  private ShopPaytypeDao shopPaytypeDao;
  @Autowired
  private SystemUtilService systemUtilService;
  @Autowired
  private SourceTypeDao paytypeDao;
  @Autowired
  private PaytypeConfigDao paytypeConfigDao;
  @Autowired
  private ShopPaytypeConfigDao shopPaytypeConfigDao;





  @Override
  public TShopPaytype getShopPaytype(String shopaccno, String paytype) {
    return shopPaytypeDao.getById(paytype, shopaccno);
  }



  @Override
  public List<TShopPaytypeConfig> getShopPaytypeConfigs(String shopaccno, String paytype) {
    List<TShopPaytypeConfig> result = new ArrayList<>(0);
    if (!StringUtil.isEmpty(paytype)) {
      List<TPaytypeConfig> list = paytypeConfigDao.getByPaytypeOrderByConfigid(paytype.trim());
      if (!StringUtil.isEmpty(list)) {
        for (TPaytypeConfig pt : list) {
          TShopPaytypeConfig spc = shopPaytypeConfigDao.getShopPaytypeConfigById(shopaccno, pt.getPaytype(), pt.getConfigid());
          if (null == spc) {
            spc = new TShopPaytypeConfig();
            spc.setShopaccno(shopaccno);
            spc.setPaytype(pt.getPaytype());
            spc.setConfigid(pt.getConfigid());
            spc.setConfigName(pt.getConfigName());
            spc.setConfigValue(null);
          }
          result.add(spc);
        }
      }
    }
    return result;
  }

}
