package com.supwisdom.dlpay.util;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

import javax.crypto.*;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

/**
 * 加密/解密工具类
 */
public class DESedeUtil {
  /**
   * 加密工具类唯一实例
   */
  private static DESedeUtil instance = null;
  /**
   *
   */
  private Cipher cipher;
  /**
   *
   */
  private SecretKey secretKey;
  /**
   *
   */
  private IvParameterSpec ivSpec;

  /**
   * 初始化、创建密钥数据
   *
   * @throws NoSuchPaddingException
   * @throws NoSuchAlgorithmException
   */
  private DESedeUtil(String deskey) throws NoSuchAlgorithmException, NoSuchPaddingException {
    byte[] keyData = Base64.decodeBase64(deskey);
    String fullAlg = "DESede/CBC/PKCS5Padding";
    cipher = Cipher.getInstance(fullAlg);
    int blockSize = cipher.getBlockSize();
    byte[] iv = new byte[blockSize];
    for (int i = 0; i < blockSize; ++i) {
      iv[i] = 0;
    }
    secretKey = new SecretKeySpec(keyData, StringUtils.substringBefore(fullAlg, "/"));
    ivSpec = new IvParameterSpec(iv);
  }

  /**
   * 获取唯一实例
   *
   * @return
   * @throws NoSuchPaddingException
   * @throws NoSuchAlgorithmException
   */
  public static DESedeUtil getInstance(String deskey) throws NoSuchAlgorithmException, NoSuchPaddingException {
    if (null == instance) {
      synchronized (DESedeUtil.class) {
        if (null == instance) {
          instance = new DESedeUtil(deskey);
        }
      }
    }
    return instance;
  }

  /**
   * 加密
   *
   * @param s 待加密字符串
   * @return 返回BASE64编码加密字符串
   * @throws InvalidAlgorithmParameterException
   * @throws InvalidKeyException
   * @throws BadPaddingException
   * @throws IllegalBlockSizeException
   * @throws UnsupportedEncodingException
   */
  public String encode(String s) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
    cipher.init(Cipher.ENCRYPT_MODE, secretKey, ivSpec);
    byte[] cipherBytes = cipher.doFinal(s.getBytes("UTF-8"));
    return new String(Base64.encodeBase64(cipherBytes));
  }

  /**
   * 解密
   *
   * @param s 待解密字符串
   * @return 返回明文
   * @throws InvalidAlgorithmParameterException
   * @throws InvalidKeyException
   * @throws BadPaddingException
   * @throws IllegalBlockSizeException
   * @throws UnsupportedEncodingException
   */
  public String decode(String s) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
    cipher.init(Cipher.DECRYPT_MODE, secretKey, ivSpec);
    byte[] resultBytes = cipher.doFinal(Base64.decodeBase64(s));
    return new String(resultBytes, "UTF-8");
  }

}

