package com.supwisdom.dlpay.util;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.*;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DlpayUtil {
  /**
   * socket方式请求农商行
   */
  public static String send(String ip, int port, int timeout, String data) throws UnknownHostException, IOException {
    Socket client = new Socket(ip, port);
    client.setSoTimeout(timeout * 1000); //timeout秒
    PrintWriter printWriter = new PrintWriter(client.getOutputStream());
    // 发送消息
    printWriter.println(data);
    printWriter.flush();

    // 读取返回信息
    InputStreamReader streamReader = new InputStreamReader(client.getInputStream());
    BufferedReader reader = new BufferedReader(streamReader);
    StringBuffer content = new StringBuffer(); //存返回信息
    int ch;
    while ((ch = reader.read()) != -1) {
      content.append((char) ch);
    }
    reader.close();
    client.close();
    return content.toString();
  }

  /**
   * XML解析返回Map
   * */
  public static Map<String, Object> getXMLValue(String xml, String charset) {
    if (null == xml) return null;
    if (null == charset) charset = "UTF-8"; //默认 UTF-8
    try {
      byte[] data = xml.getBytes(charset);
      ByteArrayInputStream bin = new ByteArrayInputStream(data);
      SAXReader reader = new SAXReader();
      Document document = reader.read(bin);
      Element root = document.getRootElement();
      List<Element> elementList = root.elements();
      Map<String, Object> map = new HashMap<>(0);
      for (Element e : elementList) {
        map.put(e.getName(), getElementValue(e));
      }
      return map;
    } catch (Exception e) {
      e.printStackTrace();
      return null;
    }
  }

  private static Object getElementValue(Element root) {
    if (null == root) return null;
    if (root.elements().size() > 0) {
      List<Element> elementList = root.elements();
      Map<String, Object> map = new HashMap<>(0);
      for (Element e : elementList) {
        map.put(e.getName(), getElementValue(e));
      }
      return map;
    } else {
      return root.getText();
    }
  }
}
