package com.supwisdom.dlpay.water.dao;

import com.supwisdom.dlpay.water.domain.TAccdtl;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;

import javax.persistence.LockModeType;
import javax.persistence.QueryHint;

@Repository
public interface AccdtlDao extends CrudRepository<TAccdtl, String> {
    @Lock(LockModeType.PESSIMISTIC_WRITE)
    @Query("select t from TAccdtl t where t.billno=?1")
    @QueryHints({@QueryHint(name = "javax.persistence.lock.timeout", value = "0")})
    TAccdtl findByBillnoForUpdate(String billno);

    TAccdtl findByBillno(String billno);
}