package com.supwisdom.dlpay.water.dao;

import com.supwisdom.dlpay.water.domain.TArea;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

@Repository
public interface AreaDao extends JpaRepository<TArea, Integer> {

    List<TArea> findAllByAvailableOrderByAreano(Integer available);

    List<TArea> findByAvailableAndLevelNot(Integer available, Integer level);

    Optional<TArea> findByAvailableAndAreano(Integer available, Integer regino);

    Page<TArea> findAllByAvailableOrderByAreano(Integer available, Pageable pageable);

    Page<TArea> findByAvailableAndParentIdOrderByAreano(Integer available, Integer parentId, Pageable pageable);

    Page<TArea> findAllByAvailableAndAreaNameContainingOrderByAreano(Integer available, String regiName, Pageable pageable);

    TArea findAllByAvailableAndAreaName(Integer available, String reiName);

    TArea findByAvailableAndAreaNameAndAreanoNot(Integer available, String reiName, Integer regino);

    List<TArea> findByAvailableAndParentId(Integer available, Integer parentId);

    Page<TArea> findByAvailableAndAreano(Integer available, Integer regino,Pageable pageable);
}
