package com.supwisdom.dlpay.water.dao;

import com.supwisdom.dlpay.water.domain.TCollectdtl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;

import javax.persistence.LockModeType;
import javax.persistence.QueryHint;
import java.util.List;

@Repository
public interface CollectdtlDao extends CrudRepository<TCollectdtl, Integer> {
    @Lock(LockModeType.PESSIMISTIC_WRITE)
    @Query("select t from TCollectdtl t where t.cobillno=?1")
    @QueryHints({@QueryHint(name = "javax.persistence.lock.timeout", value = "0")})
    TCollectdtl findByCobillnoForUpdate(Integer cobillno);

    @Lock(LockModeType.PESSIMISTIC_WRITE)
    @Query("select t from TCollectdtl t where t.entryno=?1")
    @QueryHints({@QueryHint(name = "javax.persistence.lock.timeout", value = "0")})
    TCollectdtl findByEntrynoForUpdate(String entryno);

    @Lock(LockModeType.PESSIMISTIC_WRITE)
    @Query("select t from TCollectdtl  t where t.status='wip'")
    @QueryHints({@QueryHint(name = "javax.persistence.lock.timeout", value = "0")})
    List<TCollectdtl> findWipCollectdtl(Pageable pageable);

    TCollectdtl findByCobillnoAndDeviceno(Integer cobillno, String deviceno);
}
