package com.supwisdom.dlpay.water.dao;

import com.supwisdom.dlpay.water.domain.TDevice;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface DeviceDao extends JpaRepository<TDevice, Integer>, JpaSpecificationExecutor<TDevice> {

  List<TDevice> findByAreano(Integer regino);

  TDevice findByDevicenoAndDeviceidNot(String deviceno, Integer deviceid);

  TDevice findByDevicenameAndDeviceidNot(String devicename, Integer deviceid);

  TDevice findByDevicename(String devicename);

  TDevice findByDeviceno(String deviceno);

  Page<TDevice> findAllByOrderByDeviceno(Pageable pageable);

}
