package com.supwisdom.dlpay.water.dao;

import com.supwisdom.dlpay.water.domain.TdtlCountDate;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.stereotype.Repository;

import javax.persistence.LockModeType;
import javax.persistence.QueryHint;

@Repository
public interface DtlCountDateDao extends JpaRepository<TdtlCountDate,Integer> {
    @Lock(LockModeType.PESSIMISTIC_WRITE)
    @Query("select t from TdtlCountDate t where t.id=1")
    @QueryHints({@QueryHint(name = "javax.persistence.lock.timeout", value = "0")})
    TdtlCountDate findCountDateForUpdate();
}
