package com.supwisdom.dlpay.water.dao;

import com.supwisdom.dlpay.water.domain.TAreapara;
import com.supwisdom.dlpay.water.domain.TAreaparaPK;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface TAreaparaDao extends JpaRepository<TAreapara, TAreaparaPK> {

    @Query("from TAreapara t where t.groupid=?1 order by t.paraname")
    List<TAreapara> findByGroupid(Integer groupid);

    @Query("select t from TAreapara t,TAreaparaGroup g where t.groupid=g.groupid and g.globalflag=true order by t.paraname ")
    List<TAreapara> findSystemDefaultAreapara();

    @Query("from TAreapara t where t.groupid=?1 and t.paraname=?2")
    TAreapara findById(Integer groupid, String paraname);

    void deleteAllByGroupid(Integer groupid);
}
