package com.supwisdom.dlpay.water.dao;

import com.supwisdom.dlpay.water.domain.TAreaparaGroup;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface TAreaparaGroupDao extends JpaRepository<TAreaparaGroup,Integer> {
    Page<TAreaparaGroup> findByGroupnameIsContaining(String groupname, Pageable pageable);

    TAreaparaGroup findByGroupid(Integer groupid);

    List<TAreaparaGroup> findAllByOrderByGroupid();

    @Query("select count(t.groupid) from TAreaparaGroup t where t.groupname=?1 ")
    long checkGroupnameExists(String groupname);

    @Query("select count(t.groupid) from TAreaparaGroup t where t.groupname=?1 and t.groupid<>?2")
    long checkGroupnameExists(String groupname, int groupid);
}
