package com.supwisdom.dlpay.water.domain;

import javax.persistence.*;
import javax.validation.constraints.NotNull;

@Entity
@Table(name = "tb_accentrydtl",
        indexes = {@Index(name = "accdtl_userid", columnList = "userid"),
                @Index(name = "accdtl_status", columnList = "status"),
                @Index(name = "accdtl_acc", columnList = "accdate")})
public class TAccdtl {
    @Id
    @Column(name = "billno", length = 32)
    private String billno;

    @Column(length = 16)
    private String status;

    @Column(name = "transdate", length = 14)
    @NotNull
    private String transDate;

    @Column(name = "transtime", length = 6)
    @NotNull
    private String transTime;

    @Column(length = 8)
    @NotNull
    private String deviceno;

    @Column(length = 32)
    private String userid;

    @Column(name = "citizencardno", length = 32)
    private String citizenCardno;

    @Column(length = 20)
    @NotNull
    private String mode;

    @Column(precision = 10, scale = 2)
    private Double amount;

    @Column(name = "water_in_100ml", precision = 10)
    private Integer waterSumHundredLitre;

    @Column(name = "accdate", length = 8)
    private String accdate;

    @Column(name = "cardphyid",length = 60)
    private String cardPhyId;

    @Column(name = "refno", length = 32)
    private String refno;


    public String getRefno() {
        return refno;
    }

    public void setRefno(String refno) {
        this.refno = refno;
    }

    public String getBillno() {
        return billno;
    }

    public void setBillno(String billno) {
        this.billno = billno;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTransDate() {
        return transDate;
    }

    public void setTransDate(String transDate) {
        this.transDate = transDate;
    }

    public String getTransTime() {
        return transTime;
    }

    public void setTransTime(String transTime) {
        this.transTime = transTime;
    }

    public String getDeviceno() {
        return deviceno;
    }

    public void setDeviceno(String deviceno) {
        this.deviceno = deviceno;
    }

    public String getUserid() {
        return userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getCitizenCardno() {
        return citizenCardno;
    }

    public void setCitizenCardno(String citizenCardno) {
        this.citizenCardno = citizenCardno;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Double getAmount() {
        return amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public Integer getWaterSumHundredLitre() {
        return waterSumHundredLitre;
    }

    public void setWaterSumHundredLitre(Integer waterSumHundredLitre) {
        this.waterSumHundredLitre = waterSumHundredLitre;
    }

    public String getAccdate() {
        return accdate;
    }

    public void setAccdate(String accdate) {
        this.accdate = accdate;
    }

    public String getCardPhyId() {
        return cardPhyId;
    }

    public void setCardPhyId(String cardPhyId) {
        this.cardPhyId = cardPhyId;
    }
}