package com.supwisdom.dlpay.water.domain;


import javax.persistence.*;

@Entity
@Table(name = "TB_AREA")
@SequenceGenerator(name = "SEQ_AREA", sequenceName = "SEQ_AREA", allocationSize = 1,initialValue = 2)
public class TArea {
  @Id
  @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "SEQ_AREA")
  @Column(name = "areano", nullable = false)
  private Integer areano;

  @Column(name = "PARENTID")
  private Integer parentId;

  @Column(name = "AREANAME", length = 200)
  private String areaName;

  @Column(name = "AREALEVEL", length = 10)
  private Integer level;

  @Column(name = "ADDRESS")
  private String address;

  @Column(name = "REMARKS")
  private String remarks;

  @Transient
  private String parentName;

  @Column(name = "AVAILABLE")
  private Integer available;

  public Integer getAvailable() {
    return available;
  }

  public void setAvailable(Integer available) {
    this.available = available;
  }

  public String getParentName() {
    return parentName;
  }

  public void setParentName(String parentName) {
    this.parentName = parentName;
  }

  public Integer getAreano() {
    return areano;
  }

  public void setAreano(Integer areano) {
    this.areano = areano;
  }

  public Integer getParentId() {
    return parentId;
  }

  public void setParentId(Integer parentId) {
    this.parentId = parentId;
  }

  public String getAreaName() {
    return areaName;
  }

  public void setAreaName(String areaName) {
    this.areaName = areaName;
  }

  public Integer getLevel() {
    return level;
  }

  public void setLevel(Integer level) {
    this.level = level;
  }

  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = address;
  }

  public String getRemarks() {
    return remarks;
  }

  public void setRemarks(String remarks) {
    this.remarks = remarks;
  }
}
