package com.supwisdom.dlpay.water.domain;

import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.MoneyUtil;
import com.supwisdom.dlpay.framework.util.NumberUtil;
import com.supwisdom.dlpay.framework.util.StringUtil;

import javax.persistence.*;

@Entity
@Table(name = "TB_AREAPARA")
@IdClass(TAreaparaPK.class)
public class TAreapara {
    @Id
    @Column(name="GROUPID", nullable = false, precision = 9)
    private Integer groupid;

    @Id
    @Column(name="PARANAME", nullable = false, length = 60)
    private String paraname;

    @Column(name="PARAVAL",  length = 90)
    private String paraval;

    @Column(name="PARADESC",  length = 200)
    private String paradesc;

    @Column(name="VALTYPE",  length = 10)
    private String valtype;

    @Column(name="MINVAL",  length = 10)
    private String minval;

    @Column(name="MAXVAL",  length = 10)
    private String maxval;

    @Transient
    private String errmsg;

    public Integer getGroupid() {
        return groupid;
    }

    public void setGroupid(Integer groupid) {
        this.groupid = groupid;
    }

    public String getParaname() {
        return paraname;
    }

    public void setParaname(String paraname) {
        this.paraname = paraname;
    }

    public String getParaval() {
        return paraval;
    }

    public void setParaval(String paraval) {
        this.paraval = paraval;
    }

    public String getParadesc() {
        return paradesc;
    }

    public void setParadesc(String paradesc) {
        this.paradesc = paradesc;
    }

    public String getValtype() {
        return valtype;
    }

    public void setValtype(String valtype) {
        this.valtype = valtype;
    }

    public String getMinval() {
        return minval;
    }

    public void setMinval(String minval) {
        this.minval = minval;
    }

    public String getMaxval() {
        return maxval;
    }

    public void setMaxval(String maxval) {
        this.maxval = maxval;
    }

    public String getErrmsg() {
        return errmsg;
    }

    public void setErrmsg(String errmsg) {
        this.errmsg = errmsg;
    }

    public boolean checkValue() {
        String paraname = this.paraname == null ? "" : this.paraname;

        if (StringUtil.isEmpty(this.paraval)) {
            this.errmsg = paraname + " 参数值为空";
            return false;
        }
        this.paraval = this.paraval.trim();

        //B-boolean;N-number;A-amount;S-String;DT-'yyyyMMddHHmmss';D-'yyyyMMdd';T-'HHmmss'
        if (!StringUtil.isEmpty(this.valtype) && !"S".equals(this.valtype)) {
            //指定了值类型
            if ("B".equals(this.valtype)) {
                //boolean
                if (!"0".equals(this.paraval) && !"1".equals(this.paraval)) {
                    this.errmsg = paraname + " 只能取0或1 ";
                    return false;
                }
            }

            if ("N".equals(this.valtype)) {
                // number
                if (!NumberUtil.isDigits(this.paraval)) {
                    this.errmsg = paraname + " 只能取整数 ";
                    return false;
                }
                if (NumberUtil.isDigits(this.minval) && Long.parseLong(this.paraval) < Long.parseLong(this.minval)) {
                    this.errmsg = paraname + " 小于最小值(" + Long.parseLong(this.minval) + ") ";
                    return false;
                }
                if (NumberUtil.isDigits(this.maxval) && Long.parseLong(this.paraval) > Long.parseLong(this.maxval)) {
                    this.errmsg = paraname + " 大于最大值(" + Long.parseLong(this.maxval) + ") ";
                    return false;
                }
            }

            if ("A".equals(this.valtype)) {
                //金额amount
                if (!NumberUtil.isAmount(this.paraval)) {
                    this.errmsg = paraname + " 为金额，最多两位小数 ";
                    return false;
                }
                if (NumberUtil.isAmount(this.minval) && MoneyUtil.moneyCompare(Double.parseDouble(this.paraval), Double.parseDouble(this.minval)) < 0) {
                    this.errmsg = paraname + " 小于最小值(" + MoneyUtil.formatYuan(Double.parseDouble(this.minval)) + ") ";
                    return false;
                }
                if (NumberUtil.isAmount(this.maxval) && MoneyUtil.moneyCompare(Double.parseDouble(this.paraval), Double.parseDouble(this.maxval)) > 0) {
                    this.errmsg = paraname + " 大于最大值(" + MoneyUtil.formatYuan(Double.parseDouble(this.maxval)) + ") ";
                    return false;
                }
            }

            if ("DT".equals(this.valtype)) {
                //时间 yyyyMMddHHmmss
                if (!DateUtil.checkDatetimeValid(this.paraval, "yyyyMMddHHmmss")) {
                    this.errmsg = paraname + " 格式错误(yyyyMMddHhmmss) ";
                    return false;
                }

                if (!StringUtil.isEmpty(this.minval) && DateUtil.compareDatetime(this.paraval, this.minval, "yyyyMMddHHmmss") < 0) {
                    this.errmsg = paraname + " 小于最小值(" + this.minval + ") ";
                    return false;
                }
                if (!StringUtil.isEmpty(this.maxval) && DateUtil.compareDatetime(this.paraval, this.maxval, "yyyyMMddHHmmss") > 0) {
                    this.errmsg = paraname + " 大于最大值(" + this.maxval + ") ";
                    return false;
                }
            }

            if ("D".equals(this.valtype)) {
                //时间 yyyyMMdd
                if (!DateUtil.checkDatetimeValid(this.paraval, "yyyyMMdd")) {
                    this.errmsg = paraname + " 格式错误(yyyyMMdd) ";
                    return false;
                }

                if (!StringUtil.isEmpty(this.minval) && DateUtil.compareDatetime(this.paraval, this.minval, "yyyyMMdd") < 0) {
                    this.errmsg = paraname + " 小于最小值(" + this.minval + ") ";
                    return false;
                }
                if (!StringUtil.isEmpty(this.maxval) && DateUtil.compareDatetime(this.paraval, this.maxval, "yyyyMMdd") > 0) {
                    this.errmsg = paraname + " 大于最大值(" + this.maxval + ") ";
                    return false;
                }
            }

            if ("T".equals(this.valtype)) {
                //时间 HHmmss
                if (!DateUtil.checkDatetimeValid(this.paraval, "HHmmss")) {
                    this.errmsg = paraname + " 格式错误(HHmmss) ";
                    return false;
                }

                if (!StringUtil.isEmpty(this.minval) && DateUtil.compareDatetime(this.paraval, this.minval, "HHmmss") < 0) {
                    this.errmsg = paraname + " 小于最小值(" + this.minval + ") ";
                    return false;
                }
                if (!StringUtil.isEmpty(this.maxval) && DateUtil.compareDatetime(this.paraval, this.maxval, "HHmmss") > 0) {
                    this.errmsg = paraname + " 大于最大值(" + this.maxval + ") ";
                    return false;
                }
            }

            if ("TS".equals(this.valtype)){
                //时间(时分) HHmm
                if (!DateUtil.checkDatetimeValid(this.paraval, "HHmm")) {
                    this.errmsg = paraname + " 格式错误(HHmm) ";
                    return false;
                }

                if (!StringUtil.isEmpty(this.minval) && DateUtil.compareDatetime(this.paraval, this.minval, "HHmm") < 0) {
                    this.errmsg = paraname + " 小于最小值(" + this.minval + ") ";
                    return false;
                }
                if (!StringUtil.isEmpty(this.maxval) && DateUtil.compareDatetime(this.paraval, this.maxval, "HHmm") > 0) {
                    this.errmsg = paraname + " 大于最大值(" + this.maxval + ") ";
                    return false;
                }
            }

        } else {
            //字符串判断
            if (!StringUtil.isEmpty(this.minval) && this.paraval.compareToIgnoreCase(this.minval) < 0) {
                this.errmsg = paraname + " 小于最小值(" + this.minval + ") ";
                return false;
            }
            if (!StringUtil.isEmpty(this.maxval) && this.paraval.compareToIgnoreCase(this.maxval) > 0) {
                this.errmsg = paraname + " 大于最大值(" + this.maxval + ") ";
                return false;
            }
        }
        return true;
    }
}

