package com.supwisdom.dlpay.water.domain;

import javax.persistence.Column;
import javax.persistence.Id;
import java.io.Serializable;

public class TAreaparaPK implements Serializable {
    @Id
    @Column(name = "GROUPID", nullable = false, precision = 9)
    private Integer groupid;

    @Id
    @Column(name = "PARANAME", nullable = false, length = 60)
    private String paraname;

    public TAreaparaPK() {
    }

    public TAreaparaPK(Integer groupid, String paraname) {
        this.groupid = groupid;
        this.paraname = paraname;
    }

    public Integer getGroupid() {
        return groupid;
    }

    public void setGroupid(Integer groupid) {
        this.groupid = groupid;
    }

    public String getParaname() {
        return paraname;
    }

    public void setParaname(String paraname) {
        this.paraname = paraname;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TAreaparaPK tAreaparaPK = (TAreaparaPK) o;
        if (groupid != null ? !groupid.equals(tAreaparaPK.getGroupid()) : groupid != null)
            return false;
        if (paraname != null ? !paraname.equals(tAreaparaPK.getParaname()) : paraname != null)
            return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = groupid != null ? groupid.hashCode() : 0;
        result = 31 * result + (paraname != null ? paraname.hashCode() : 0);
        return result;
    }
}
