package com.supwisdom.dlpay.water.domain;

import javax.persistence.*;
import javax.validation.constraints.NotNull;

@Entity
@Table(name = "tb_collectdtl",
    indexes = {@Index(name = "collectdtl_userid", columnList = "userid"),
        @Index(name = "collectdtl_status", columnList = "transdate, status"),
        @Index(name = "collectdtl_acc", columnList = "accdate")})
@SequenceGenerator(name = "SEQ_COLLECT_BILLNO", sequenceName = "SEQ_COLLECT_BILLNO", allocationSize = 1)
public class TCollectdtl {
  @Id
  @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "SEQ_COLLECT_BILLNO")
  @Column(name = "cobillno", nullable = false)
  private Integer cobillno;

  @Column(name = "transdate", length = 14)
  @NotNull
  private String transDate;

  @Column(name = "transtime", length = 6)
  @NotNull
  private String transTime;

  @Column(length = 8)
  @NotNull
  private String deviceno;

  @Column(length = 32)
  private String userid;

  @Column(name = "citizencardno", length = 32)
  private String citizenCardno;

  @Column(length = 20)
  @NotNull
  private String mode;

  @Column(precision = 10, scale = 2)
  private Double amount;

  @Column(name = "water_in_100ml", precision = 10)
  private Integer waterSumHundredLitre;

  @Column(length = 16)
  @NotNull
  private String status;

  @Column(name = "uploadtime", length = 14)
  private String uploadTime;

  @Column(name = "accdate", length = 8)
  private String accdate;

  @Column(name = "entryno", length = 32)
  private String entryno;

  @Column(name = "authstatus")
  private Boolean authStatus;

  @Column(name = "uploadstatus")
  private Boolean uploadStatus;

  @Column(name = "cardphyid",length = 60)
  private String cardPhyId;

  public String getCardPhyId() {
    return cardPhyId;
  }

  public void setCardPhyId(String cardPhyId) {
    this.cardPhyId = cardPhyId;
  }

  public Boolean getUploadStatus() {
    return uploadStatus;
  }

  public void setUploadStatus(Boolean uploadStatus) {
    this.uploadStatus = uploadStatus;
  }

  public Boolean getAuthStatus() {
    return authStatus;
  }

  public void setAuthStatus(Boolean authStatus) {
    this.authStatus = authStatus;
  }

  public Integer getCobillno() {
    return cobillno;
  }

  public void setCobillno(Integer cobillno) {
    this.cobillno = cobillno;
  }

  public String getDeviceno() {
    return deviceno;
  }

  public void setDeviceno(String deviceno) {
    this.deviceno = deviceno;
  }

  public String getTransDate() {
    return transDate;
  }

  public void setTransDate(String transDate) {
    this.transDate = transDate;
  }

  public String getTransTime() {
    return transTime;
  }

  public void setTransTime(String transTime) {
    this.transTime = transTime;
  }

  public String getUserid() {
    return userid;
  }

  public void setUserid(String userid) {
    this.userid = userid;
  }

  public String getCitizenCardno() {
    return citizenCardno;
  }

  public void setCitizenCardno(String citizenCardno) {
    this.citizenCardno = citizenCardno;
  }

  public String getMode() {
    return mode;
  }

  public void setMode(String mode) {
    this.mode = mode;
  }

  public Double getAmount() {
    return amount;
  }

  public void setAmount(Double amount) {
    this.amount = amount;
  }

  public Integer getWaterSumHundredLitre() {
    return waterSumHundredLitre;
  }

  public void setWaterSumHundredLitre(Integer waterSumHundredLitre) {
    this.waterSumHundredLitre = waterSumHundredLitre;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getUploadTime() {
    return uploadTime;
  }

  public void setUploadTime(String uploadTime) {
    this.uploadTime = uploadTime;
  }

  public String getAccdate() {
    return accdate;
  }

  public void setAccdate(String accdate) {
    this.accdate = accdate;
  }

  public String getEntryno() {
    return entryno;
  }

  public void setEntryno(String entryno) {
    this.entryno = entryno;
  }

}
