package com.supwisdom.dlpay.water.domain;

import javax.persistence.*;

@Entity
@Table(name = "TB_DEVICE")
public class TDevice {
  @Id
  @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "deviceid_seq")
  @SequenceGenerator(name = "deviceid_seq", sequenceName = "seq_deviceid", allocationSize = 1,initialValue = 2)
  private Integer deviceid;

  @Column(name = "deviceno", nullable = false, length = 8)
  private String deviceno;

  @Column(name = "devicename", length = 200)
  private String devicename;

  @Column(name = "DEVISTATUS", length = 10)
  private String deviceStatus;

  @Column(name = "AREANO")
  private Integer areano;

  @Column(name = "linecheck", length = 14)
  private String deviceLineCheck; // 心跳更新时间

  @Column(name = "soft_verno", length = 30)
  private String softVer; // 软件版本

  @Transient
  private String areaname;

  public String getAreaname() {
    return areaname;
  }

  public void setAreaname(String areaname) {
    this.areaname = areaname;
  }

  public Integer getDeviceid() {
    return deviceid;
  }

  public void setDeviceid(Integer deviceid) {
    this.deviceid = deviceid;
  }

  public String getDeviceno() {
    return deviceno;
  }

  public void setDeviceno(String deviceno) {
    this.deviceno = deviceno;
  }

  public String getDevicename() {
    return devicename;
  }

  public void setDevicename(String devicename) {
    this.devicename = devicename;
  }

  public String getDeviceStatus() {
    return deviceStatus;
  }

  public void setDeviceStatus(String deviceStatus) {
    this.deviceStatus = deviceStatus;
  }

  public Integer getAreano() {
    return areano;
  }

  public void setAreano(Integer areano) {
    this.areano = areano;
  }

  public String getDeviceLineCheck() {
    return deviceLineCheck;
  }

  public void setDeviceLineCheck(String deviceLineCheck) {
    this.deviceLineCheck = deviceLineCheck;
  }

  public String getSoftVer() {
    return softVer;
  }

  public void setSoftVer(String softVer) {
    this.softVer = softVer;
  }
}
