package com.supwisdom.dlpay.water.domain;


import javax.persistence.*;

@Entity
@Table(name = "tb_transdtl_count",
        indexes = {@Index(name = "trasndtl_count_accdate", columnList = "accdate"),
                @Index(name = "transdtl_count_areano", columnList = "areano"),
                @Index(name = "transdtl_count_idx", columnList = "accdate, areano, deviceno,mode", unique = true)})
@SequenceGenerator(name = "SEQ_TRANSDTL_COUNT", sequenceName = "SEQ_TRANSDTL_COUNT", allocationSize = 1, initialValue = 1000)
public class TTransdtlCount {
    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "SEQ_TRANSDTL_COUNT")
    @Column(name = "id", length = 18)
    private Integer id;

    @Column(name = "accdate", length = 8)
    private String accdate;

    @Column(name = "areano")
    private Integer areano;

    @Column(name = "deviceno", length = 8)
    private String deviceno;

    @Column(name = "mode", length = 20)
    private String mode;

    @Column(name = "count", length = 32)
    private Integer count;

    @Column(precision = 10, scale = 2)
    private Double amount;

    @Column(name = "water", precision = 10)
    private Integer water;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getAccdate() {
        return accdate;
    }

    public void setAccdate(String accdate) {
        this.accdate = accdate;
    }

    public Integer getAreano() {
        return areano;
    }

    public void setAreano(Integer areano) {
        this.areano = areano;
    }

    public String getDeviceno() {
        return deviceno;
    }

    public void setDeviceno(String deviceno) {
        this.deviceno = deviceno;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Double getAmount() {
        return amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public Integer getWater() {
        return water;
    }

    public void setWater(Integer water) {
        this.water = water;
    }
}
