package com.supwisdom.dlpay.water.pay;

import com.supwisdom.dlpay.api.bean.ApiVersionResponse;
import com.supwisdom.dlpay.framework.service.BusinessparaService;
import com.supwisdom.dlpay.framework.util.WaterBudinessConstants;
import com.supwisdom.dlpay.paysdk.ApiLoginHelper;
import com.supwisdom.dlpay.paysdk.proxy.ApiCommonProxy;
import com.supwisdom.dlpay.paysdk.proxy.ApiLoginProxy;
import com.supwisdom.dlpay.water.service.CollectdtlService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.notNullValue;

@Component
@EnableFeignClients(basePackages = "com.supwisdom.dlpay.paysdk")
@ComponentScan(basePackages = {"com.supwisdom.dlpay.paysdk"})
public class PayInit {

    @Autowired
    private BusinessparaService businessparaService;

    private String appid;

    private String secret;

    @Autowired
    private ApiLoginProxy apiLoginProxy;

    @Autowired
    private ApiCommonProxy apiCommonProxy;

    @Autowired
    private CollectdtlService collectdtlService;

    @PostConstruct
    public void login() {
        appid = businessparaService.findByParakey(WaterBudinessConstants.WATER_APPID).getParaval();
        secret = businessparaService.findByParakey(WaterBudinessConstants.WATER_SECRET).getParaval();
        ApiLoginHelper helper = new ApiLoginHelper(apiLoginProxy);
        helper.login(appid, secret);
        System.out.println("向支付中心登录成功");
        ApiVersionResponse version = apiCommonProxy.apiVersion();
        assertThat("get version error " + version.getException(),
                version.getVersion(), notNullValue());
    }

    @PostConstruct
    public void initDtlCountDate() {
        collectdtlService.initDtlCountDate();
    }
}
