package com.supwisdom.dlpay.water.pay;

import com.supwisdom.dlpay.api.bean.*;
import com.supwisdom.dlpay.framework.service.BusinessparaService;
import com.supwisdom.dlpay.framework.service.SystemUtilService;
import com.supwisdom.dlpay.framework.util.*;
import com.supwisdom.dlpay.paysdk.proxy.CitizenCardPayProxy;
import com.supwisdom.dlpay.paysdk.proxy.TransactionProxy;
import com.supwisdom.dlpay.system.service.UserDataService;
import com.supwisdom.dlpay.water.domain.TAccdtl;
import com.supwisdom.dlpay.water.domain.TCollectdtl;
import com.supwisdom.dlpay.water.service.AccdtlService;
import com.supwisdom.dlpay.water.service.CollectdtlService;
import org.hamcrest.MatcherAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import static org.hamcrest.Matchers.equalTo;


@Component
public class WaterPayAsyncTask {

    private static final Logger logger = LoggerFactory.getLogger(WaterPayAsyncTask.class);

    @Autowired
    private CitizenCardPayProxy citizenCardPayProxy;

    @Autowired
    private TransactionProxy transactionProxy;

    @Autowired
    private SystemUtilService systemUtilService;

    @Autowired
    private AccdtlService accdtlService;

    @Autowired
    private UserDataService userDataService;

    @Autowired
    private CollectdtlService collectdtlService;

    @Autowired
    private BusinessparaService businessparaService;

    @Async("waterPay")
    public void waterPay(Integer cobillno) {
        TCollectdtl collectdtl = collectdtlService.findByCobillnoForUpdate(cobillno);
        if (!TradeDict.DTL_STATUS_WIP.equals(collectdtl.getStatus())) {
            logger.error("待入账的采集流水" + cobillno + "状态不正确");
            return;
        }
        if (TradeDict.PAY_MODE_CARD.equals(collectdtl.getMode())) {
            waterCardPay(collectdtl);
        } else if (TradeDict.PAY_MODE_QRCODE.equals(collectdtl.getMode())) {
            waterCardPay(collectdtl);   //刷码暂时使用刷卡扣费模式
        } else {
            logger.error("暂不支持的消费类型");
        }
    }

    private void waterCardPay(TCollectdtl collectdtl) {
        //  是否已生成入账流水
        if (collectdtl.getEntryno() != null) {
            TAccdtl accdtl = accdtlService.findByBillno(collectdtl.getEntryno());
            String accStatus = accdtl.getStatus();
            if (null == accStatus) {
                //  入账流水状态为空，需查询是否已初始化
                QueryDtlResultParam queryParam = new QueryDtlResultParam();
                queryParam.setBillno(accdtl.getBillno());
                queryParam.setShopaccno(businessparaService.findByParakey(WaterBudinessConstants.WATER_SHOP_ACCNO).getParaval());
                QueryTransDtlResponse queryResult = transactionProxy.queryDtlResult(queryParam);
                if (0 == queryResult.getRetcode()) {
                    //  流水已初始化，进行确认
                    TAccdtl initAccdtl = initAcc(queryResult.getOutTradeNo(), queryResult.getRefno());
                    payConfirm(initAccdtl);
                } else if (TradeErrorCode.TRANSACTION_NOT_EXISTS == queryResult.getRetcode()) {
                    //  流水尚未初始化，可直接扣费
                    waterPay(accdtl);
                }
            } else if (TradeDict.DTL_STATUS_FAIL.equals(accStatus)) {
                //  入账流水扣费失败，重新生成入账流水扣费
                TAccdtl newAccdtl = buildAccdtl(collectdtl);
                newAccdtl = accdtlService.creatNewAccdtl(newAccdtl, collectdtl.getCobillno());
                waterPay(newAccdtl);
            } else if (TradeDict.DTL_STATUS_INIT.equals(accStatus) ||
                    TradeDict.DTL_STATUS_WIP.equals(accStatus)) {
                //  入账流水状态为init，需查询是否已确认
                QueryDtlResultParam queryParam = new QueryDtlResultParam();
                queryParam.setRefno(accdtl.getRefno());
                QueryTransDtlResponse queryResult = transactionProxy.queryDtlResult(queryParam);
                if (0 == queryResult.getRetcode()) {
                    //  查询得到状态为init
                    if (TradeDict.DTL_STATUS_INIT.equals(queryResult.getStatus())) {
                        //  进行消费确认
                        payConfirm(accdtl);
                    } else if (TradeDict.DTL_STATUS_SUCCESS.equals(queryResult.getStatus())) {
                        //  查询得到状态为success，记录下状态
                        userDataService.updateAccamount(accdtl.getCitizenCardno(), accdtl.getAmount());
                        cofirmAcc(queryResult.getStatus(), accdtl.getBillno(), accdtl.getRefno());
                    } else if (TradeDict.DTL_STATUS_FAIL.equals(queryResult.getStatus())) {
                        cofirmAcc(queryResult.getStatus(), accdtl.getBillno(), accdtl.getRefno());
                    }
                } else if (TradeErrorCode.TRANSACTION_NOT_EXISTS == queryResult.getRetcode()) {
                    logger.error("入账流水:" + accdtl.getBillno() + "的refno:" + accdtl.getRefno() + "未找到");
                }
            }
        } else {
            //  未生成入账流水
            //  生成一条入账流水，并将其billno存入对应的采集流水
            TAccdtl accdtl = buildAccdtl(collectdtl);
            accdtl = accdtlService.creatNewAccdtl(accdtl, collectdtl.getCobillno());
            if (null == accdtl) {
                return;
            }
            //  支付中心初始化并确认入账流水
            waterPay(accdtl);
        }
    }

    private void waterPay(TAccdtl accdtl) {
        //  支付中心初始化入账流水
        CitizenCardPayinitParam initParam = buildPayInitParam(accdtl);
        CitizenPayResponse payInit = citizenCardPayProxy.citizencardPayinit(initParam);
        MatcherAssert.assertThat("pay initialized " + payInit.getRetmsg() + payInit.getException(),
                payInit.getRetcode(), equalTo(0));
        //  初始化成功记录下refno，并修改入账流水状态为init
        TAccdtl initAccdtl = initAcc(payInit.getBillno(), payInit.getRefno());
        //  支付中心确认入账流水
        payConfirm(initAccdtl);
    }

    private TAccdtl initAcc(String billno, String refno) {
        InitAccParam initAccParam = new InitAccParam();
        initAccParam.setBillno(billno);
        initAccParam.setRefno(refno);
        return accdtlService.initAcc(initAccParam);
    }

    private TAccdtl buildAccdtl(TCollectdtl collectdtl) {
        TAccdtl accdtl = new TAccdtl();
        accdtl.setDeviceno(collectdtl.getDeviceno());
        accdtl.setUserid(collectdtl.getUserid());
        accdtl.setCitizenCardno(collectdtl.getCitizenCardno());
        accdtl.setMode(TradeDict.PAY_MODE_CARD);//TODO: 二维码消费
        accdtl.setAmount(collectdtl.getAmount());
        accdtl.setWaterSumHundredLitre(collectdtl.getWaterSumHundredLitre());
        accdtl.setCardPhyId(collectdtl.getCardPhyId());
        accdtl.setTransTime(collectdtl.getTransTime());
        accdtl.setTransDate(collectdtl.getTransDate());
        return accdtl;
    }

    private CitizenCardPayinitParam buildPayInitParam(TAccdtl accdtl) {
        CitizenCardPayinitParam initParam = new CitizenCardPayinitParam();
        initParam.setBillno(accdtl.getBillno());
        initParam.setCardNo(accdtl.getCitizenCardno());
        initParam.setAmount(MoneyUtil.YuanToFen(accdtl.getAmount()));
        initParam.setDtltype(Constants.DTLTYPE_WATER);
        initParam.setTransdate(accdtl.getTransDate());
        initParam.setTranstime(accdtl.getTransTime());
        initParam.setShopaccno(businessparaService.findByParakey(WaterBudinessConstants.WATER_SHOP_ACCNO).getParaval());
        return initParam;
    }

    private void payConfirm(TAccdtl initAccdtl) {
        CitizenCardPayfinishParam finishParam = new CitizenCardPayfinishParam();
        finishParam.setRefno(initAccdtl.getRefno());
        CitizenPayResponse payFinish = citizenCardPayProxy.citizencardPayFinish(finishParam);
        //2.1   处理消费确认响应结果
        int finishRetcode = payFinish.getRetcode();
        String accStatus;
        if (finishRetcode == 0) {
            accStatus = TradeDict.DTL_STATUS_SUCCESS;
            //  更新用户已入账金额
            userDataService.updateAccamount(initAccdtl.getCitizenCardno(), initAccdtl.getAmount());
        } else if (finishRetcode == TradeErrorCode.WAIT_QUERY_RESULT) {
            QueryDtlResultParam queryParam = new QueryDtlResultParam();
            queryParam.setRefno(payFinish.getRefno());
            QueryTransDtlResponse queryResult = transactionProxy.queryDtlResult(queryParam);
            if (0 == queryResult.getRetcode()) {
                accStatus = queryResult.getStatus();
                if (TradeDict.DTL_STATUS_SUCCESS.equals(accStatus)) {
                    accStatus = TradeDict.DTL_STATUS_SUCCESS;
                    userDataService.updateAccamount(initAccdtl.getCitizenCardno(), initAccdtl.getAmount());
                }
            } else {
                accStatus = TradeDict.DTL_STATUS_WIP;
                logger.error("查询确认结果失败:" + queryResult.getRetcode() + "," + queryResult.getRetmsg());
            }
        } else if (finishRetcode == TradeErrorCode.BUSINESS_DEAL_ERROR) {
            accStatus = TradeDict.DTL_STATUS_FAIL;
        } else {
            accStatus = TradeDict.DTL_STATUS_WIP;
            logger.error("未知的确认状态码:" + finishRetcode + "," + payFinish.getRetmsg());
        }
        //2.2   记录消费确认
        cofirmAcc(accStatus, payFinish.getBillno(), payFinish.getRefno());
    }

    private void cofirmAcc(String accStatus, String billno, String refno) {
        ConfirmAccParam accParam = new ConfirmAccParam();
        accParam.setAccdate(systemUtilService.getSysdatetime().getHostdate());
        accParam.setAccstatus(accStatus);
        accParam.setBillno(billno);
        accParam.setRefno(refno);
        accdtlService.confirmAcc(accParam);
    }
}
