package com.supwisdom.dlpay.water.service;


import com.supwisdom.dlpay.api.bean.ConfirmAccParam;
import com.supwisdom.dlpay.api.bean.InitAccParam;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.water.bean.TransdtlSearchBean;
import com.supwisdom.dlpay.water.domain.TAccdtl;
import com.supwisdom.dlpay.water.pojo.TAccdtlDTO;
import org.springframework.transaction.annotation.Transactional;

public interface AccdtlService {
    @Transactional(rollbackFor = Exception.class)
    TAccdtl initAcc(InitAccParam param);

    @Transactional(rollbackFor = Exception.class)
    TAccdtl confirmAcc(ConfirmAccParam param);

    @Transactional(rollbackFor = Exception.class)
    TAccdtl creatNewAccdtl(TAccdtl accdtl, Integer cobillno);

    @Transactional(rollbackFor = Exception.class)
    TAccdtl findByBillno(String billno);

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    PageResult<TAccdtlDTO> queryAccdtlByParam(TransdtlSearchBean param);
}
