package com.supwisdom.dlpay.water.service;

import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.water.bean.RegionSearchBean;
import com.supwisdom.dlpay.water.domain.TArea;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

public interface AreaService {
  @Transactional(rollbackFor = Exception.class)
  PageResult<TArea> queryAreasByParentId(RegionSearchBean param);

  @Transactional(rollbackFor = Exception.class)
  List<Map<String, Object>> getAreaTree(List<TArea> regions, Integer parentId);

  @Transactional(rollbackFor = Exception.class)
  List<TArea> queryAllAreas();

  @Transactional(rollbackFor = Exception.class)
  List<TArea> queryAllNotFLevelArea();

  @Transactional(rollbackFor = Exception.class)
  PageResult<TArea> queryAreasBySearchKey(RegionSearchBean param);

  @Transactional(rollbackFor = Exception.class)
  boolean saveArea(TArea region);

  @Transactional(rollbackFor = Exception.class)
  boolean checkAreaName(TArea region);

  @Transactional(rollbackFor = Exception.class)
  boolean updateArea(TArea region);

  @Transactional(rollbackFor = Exception.class)
  boolean deleteArea(Integer regino);

  @Transactional(rollbackFor = Exception.class)
  boolean existSubArea(Integer regino);

  @Transactional(rollbackFor = Exception.class,readOnly = true)
  PageResult<TArea> queryAreaByAreaNo(Integer areano);

  @Transactional(rollbackFor = Exception.class,readOnly = true)
  TArea findByAreaNo(Integer areano);
}
