package com.supwisdom.dlpay.water.service;

import com.supwisdom.dlpay.api.bean.UserInforResponse;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.water.StartWaterRequest;
import com.supwisdom.dlpay.water.UploadRecordRequest;
import com.supwisdom.dlpay.water.bean.TransdtlCountSearchBean;
import com.supwisdom.dlpay.water.domain.TCollectdtl;
import com.supwisdom.dlpay.water.pojo.TCollectdtlDTO;
import com.supwisdom.dlpay.water.bean.TransdtlSearchBean;
import com.supwisdom.dlpay.water.pojo.TTransdtlCountVO;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


public interface CollectdtlService {
    @Transactional(rollbackFor = Exception.class)
    TCollectdtl createNewTransdtl(TCollectdtl dtl);

    @Transactional(rollbackFor = Exception.class)
    TCollectdtl saveDeviceDtlData(UploadRecordRequest record);

    @Transactional(rollbackFor = Exception.class)
    TCollectdtl queryTrans(Integer cobillno);

    @Transactional(rollbackFor = Exception.class)
    TCollectdtl startWater(StartWaterRequest param);

    @Transactional(rollbackFor = Exception.class)
    TCollectdtl pretendAsCard(UserInforResponse param, Integer cobillno);

    @Transactional(rollbackFor = Exception.class)
    PageResult<TCollectdtlDTO> queryTransdtlDTOByParam(TransdtlSearchBean param);

    @Transactional(rollbackFor = Exception.class,readOnly = true)
    PageResult<TTransdtlCountVO> queryTransdtlCountByParam(TransdtlCountSearchBean param);

    @Transactional(rollbackFor = Exception.class)
    List<TCollectdtl> queryTransdtlNotEntry();

    @Transactional(rollbackFor = Exception.class)
    TCollectdtl findByCobillnoForUpdate(Integer cobillno);

    @Transactional(rollbackFor = Exception.class)
    void generateCountdtl();

    @Transactional(rollbackFor = Exception.class)
    void initDtlCountDate();
}
