package com.supwisdom.dlpay.water.service;

import com.supwisdom.dlpay.framework.domain.TDictionary;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.water.DeviceLineCheckParam;
import com.supwisdom.dlpay.water.DeviceLoginParam;
import com.supwisdom.dlpay.water.domain.TDevice;
import com.supwisdom.dlpay.water.domain.TFeeConfig;
import com.supwisdom.dlpay.water.bean.DeviceSearchBean;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

public interface DeviceService {
    @Transactional(rollbackFor = Exception.class)
    boolean existSubDevice(Integer areano);

    @Transactional(rollbackFor = Exception.class)
    PageResult<TDevice> queryDeviceList(DeviceSearchBean param);

    @Transactional(rollbackFor = Exception.class)
    TDevice queryDeviceById(Integer deviceid);

    @Transactional(rollbackFor = Exception.class,readOnly = true)
    TDevice queryDeviceByDeviceno(String deviceno);

    @Transactional(rollbackFor = Exception.class)
    boolean updateDevice(TDevice device);

    @Transactional(rollbackFor = Exception.class)
    boolean saveDevice(TDevice device);

    @Transactional(rollbackFor = Exception.class)
    Map<String, Object> checkParams(TDevice device);

    @Transactional(rollbackFor = Exception.class)
    boolean deleteDevice(Integer deviceid);

    @Transactional(rollbackFor = Exception.class)
    List<TDictionary> groupStatus();

    @Transactional(rollbackFor = Exception.class)
    PageResult<TDevice> queryDeviceByParams(DeviceSearchBean param);

    @Transactional(rollbackFor = Exception.class)
    PageResult<TDevice> queryAreaname(Page<TDevice> devicePage);

    @Transactional(rollbackFor = Exception.class)
    Map<String, Object> deviceLogin(DeviceLoginParam param);

    @Transactional(rollbackFor = Exception.class)
    TDevice lineCheck(DeviceLineCheckParam param);

    @Transactional(rollbackFor = Exception.class)
    TFeeConfig queryTFeeConfigByDeviceno(String deviceno);

    @Transactional(rollbackFor = Exception.class)
    Map<String, String> getParaMapByDeviceno(String deviceno);
}
