package com.supwisdom.dlpay.water.service;

import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.util.WebCheckException;
import com.supwisdom.dlpay.water.bean.AreaparaSearchBean;
import com.supwisdom.dlpay.water.domain.TArea;
import com.supwisdom.dlpay.water.domain.TAreapara;
import com.supwisdom.dlpay.water.domain.TAreaparaBind;
import com.supwisdom.dlpay.water.domain.TAreaparaGroup;
import com.supwisdom.dlpay.water.pojo.TAreaparaBindDTO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

public interface TAreaparaService {
    @Transactional(rollbackFor = Exception.class)
    PageResult<TAreaparaGroup> queryParaGroupByParam(AreaparaSearchBean param);

    @Transactional(rollbackFor = Exception.class)
    TAreaparaGroup getAreaparaGroupByGroupid(Integer groupid);

    @Transactional(rollbackFor = Exception.class)
    List<TAreapara> getAreaparaInfo(Integer groupid);

    @Transactional(rollbackFor = Exception.class)
    boolean saveOrUpdateAreapara(int groupid, String groupname, Map<String, String> param) throws WebCheckException;

    @Transactional(rollbackFor = Exception.class)
    PageResult<TAreaparaBindDTO> getAreaparaBindInfos(String searchkey, int pageNo, int pageSize);

    @Transactional(rollbackFor = Exception.class)
    boolean deleteAreaparaGroup(TAreaparaGroup group) throws WebCheckException;

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    List<TAreaparaGroup> queryAllAreaparaGroups();

    @Transactional(rollbackFor = Exception.class)
    boolean saveBindAreapara(int groupid,List<Integer> areanos) throws WebCheckException;

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    TAreaparaBind getAreaparaBindByAreano(Integer areano);

    @Transactional(rollbackFor = Exception.class)
    boolean deleteAreaparaBind(TAreaparaBind bind);

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    PageResult<TArea> getAreaBySearch(String searchKey);
}
