package com.supwisdom.dlpay.water.service.impl;

import com.supwisdom.dlpay.api.bean.ConfirmAccParam;
import com.supwisdom.dlpay.api.bean.InitAccParam;
import com.supwisdom.dlpay.framework.service.SystemUtilService;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.framework.util.TradeDict;
import com.supwisdom.dlpay.water.bean.TransdtlSearchBean;
import com.supwisdom.dlpay.water.dao.AccdtlDao;
import com.supwisdom.dlpay.water.dao.CollectdtlDao;
import com.supwisdom.dlpay.water.domain.TAccdtl;
import com.supwisdom.dlpay.water.domain.TCollectdtl;
import com.supwisdom.dlpay.water.pojo.TAccdtlDTO;
import com.supwisdom.dlpay.water.service.AccdtlService;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.math.BigInteger;
import java.util.List;


@Service
public class AccdtlServiceImpl implements AccdtlService {

    private static final Logger logger = LoggerFactory.getLogger(AccdtlServiceImpl.class);

    @Autowired
    private CollectdtlDao collectdtlDao;

    @Autowired
    private AccdtlDao accdtlDao;

    @Autowired
    private SystemUtilService systemUtilService;

    @PersistenceContext
    private EntityManager em;

    @Override
    public TAccdtl initAcc(InitAccParam param) {
        TAccdtl accdtl = accdtlDao.findByBillnoForUpdate(param.getBillno());
        if (null == accdtl) {
            logger.error("入账流水:" + param.getBillno() + "未找到");
            return null;
        }
        accdtl.setRefno(param.getRefno());
        accdtl.setStatus(TradeDict.DTL_STATUS_INIT);
        accdtlDao.save(accdtl);
        return accdtl;
    }

    @Override
    public TAccdtl confirmAcc(ConfirmAccParam param) {
        String billno = param.getBillno();
        TAccdtl accdtl = accdtlDao.findByBillnoForUpdate(billno);
        if (null == accdtl) {
            logger.error("确认入账后，未找到流水号为:" + billno + "的入账流水");
            return null;
        }
        if (!param.getRefno().equals(accdtl.getRefno())) {
            logger.error("确认入账时，支付中心确认流水号:"+param.getRefno()+"与初始化流水号:"+accdtl.getRefno()+"不相等");
            return null;
        }
        if (TradeDict.DTL_STATUS_SUCCESS.equals(param.getAccstatus())) {
            TCollectdtl collectdtl = collectdtlDao.findByEntrynoForUpdate(billno);
            if (null == collectdtl) {
                logger.error("确认入账后，未找到入账流水为:" + billno + "对应的采集流水");
                return null;
            }
            collectdtl.setAccdate(param.getAccdate());
            collectdtl.setStatus(TradeDict.DTL_STATUS_SUCCESS);
            accdtl.setAccdate(param.getAccdate());
            collectdtlDao.save(collectdtl);
        }
        accdtl.setStatus(param.getAccstatus());
        accdtlDao.save(accdtl);
        return accdtl;
    }

    @Override
    public TAccdtl creatNewAccdtl(TAccdtl accdtl,Integer cobillno) {
        TCollectdtl collectdtl = collectdtlDao.findByCobillnoForUpdate(cobillno);
        if (null == collectdtl) {
            throw new RuntimeException("采集流水号:" + cobillno + "未找到");
        }
        if (null == collectdtl.getEntryno()) {
            accdtl.setBillno(systemUtilService.getRefno());
            accdtlDao.save(accdtl);
            collectdtl.setEntryno(accdtl.getBillno());
            collectdtlDao.save(collectdtl);
            return accdtl;
        } else {
            TAccdtl oldAccdtl = accdtlDao.findByBillno(collectdtl.getEntryno());
            if (TradeDict.DTL_STATUS_FAIL.equals(oldAccdtl.getStatus())) {
                accdtl.setBillno(systemUtilService.getRefno());
                collectdtl.setEntryno(accdtl.getBillno());
                accdtlDao.save(accdtl);
                collectdtlDao.save(collectdtl);
                return accdtl;
            }
        }
        return null;
    }

    @Override
    public TAccdtl findByBillno(String billno) {
        TAccdtl accdtl = accdtlDao.findByBillno(billno);
        if (null == accdtl) {
            throw new RuntimeException("入账流水号:" + billno + "未找到");
        }
        return accdtl;
    }

    @Override
    public PageResult<TAccdtlDTO> queryAccdtlByParam(TransdtlSearchBean param) {
        StringBuffer querySql = new StringBuffer("select t1.billno,t1.amount,t1.citizencardno,t1.cardphyid,t1.deviceno,t1.mode,t1.status,t1.transdate,t1.refno,t1.transtime,t1.accdate,t1.water_in_100ml watersumhundredlitre,t1.name username,t2.devicename,t2.areaname,t2.areano " +
                "from (select dtl.*,person.name from tb_accentrydtl dtl left join tb_person person on dtl.userid = person.userid) t1," +
                "(select device.deviceno,device.devicename,area.areaname,area.areano from tb_device device,tb_area area where device.areano = area.areano) t2 " +
                "where t1.deviceno = t2.deviceno");
        StringBuffer countSql = new StringBuffer("select count(billno) " +
                "from (select dtl.*,person.name from tb_accentrydtl dtl left join tb_person person on dtl.userid = person.userid) t1," +
                "(select device.deviceno,device.devicename,area.areaname,area.areano from tb_device device,tb_area area where device.areano = area.areano) t2 " +
                "where t1.deviceno = t2.deviceno");
        if (!StringUtil.isEmpty(param.getTransdate())) {
            querySql.append(" and transdate >= :mintransdate");
            querySql.append(" and transdate <= :maxtransdate");

            countSql.append(" and transdate >= :mintransdate");
            countSql.append(" and transdate <= :maxtransdate");
        }
        if (!StringUtil.isEmpty(param.getAccdate())) {
            querySql.append(" and accdate >= :minaccdate");
            querySql.append(" and accdate <= :maxaccdate");

            countSql.append(" and accdate >= :minaccdate");
            countSql.append(" and accdate <= :maxaccdate");
        }
        if (!StringUtil.isEmpty(param.getUsername())) {
            querySql.append(" and name like :username");
            countSql.append(" and name like :username");
        }
        if (!StringUtil.isEmpty(param.getDeviceno())) {
            querySql.append(" and t1.deviceno like :deviceno");
            countSql.append(" and t1.deviceno like :deviceno");
        }
        if (!StringUtil.isEmpty(param.getDevicename())) {
            querySql.append(" and devicename like :devicename");
            countSql.append(" and devicename like :devicename");
        }
        if (null != param.getAreano()) {
            querySql.append(" and areano =:areano");
            countSql.append(" and areano =:areano");
        }
        querySql.append(" order by billno desc");
        Query query = em.createNativeQuery(querySql.toString());
        Query countQuery = em.createNativeQuery(countSql.toString());
        if (!StringUtil.isEmpty(param.getTransdate())) {
            String[] timerange = param.getTransdate().replace("-", "").split("  ");
            query.setParameter("mintransdate", timerange[0]);
            query.setParameter("maxtransdate", timerange[1]);
            countQuery.setParameter("mintransdate", timerange[0]);
            countQuery.setParameter("maxtransdate", timerange[1]);
        }
        if (!StringUtil.isEmpty(param.getAccdate())) {
            String[] timerange = param.getAccdate().replace("-", "").split("  ");
            query.setParameter("minaccdate", timerange[0]);
            query.setParameter("maxaccdate", timerange[1]);
            countQuery.setParameter("minaccdate", timerange[0]);
            countQuery.setParameter("maxaccdate", timerange[1]);
        }
        if (!StringUtil.isEmpty(param.getUsername())) {
            query.setParameter("username", "%" + param.getUsername().trim() + "%");
            countQuery.setParameter("username", "%" + param.getUsername().trim() + "%");
        }
        if (!StringUtil.isEmpty(param.getDeviceno())) {
            query.setParameter("deviceno", "%" + param.getDeviceno().trim() + "%");
            countQuery.setParameter("deviceno", "%" + param.getDeviceno().trim() + "%");
        }
        if (!StringUtil.isEmpty(param.getDevicename())) {
            query.setParameter("devicename", "%" + param.getDevicename().trim() + "%");
            countQuery.setParameter("devicename", "%" + param.getDevicename().trim() + "%");
        }
        if (null != param.getAreano()) {
            query.setParameter("areano", param.getAreano());
            countQuery.setParameter("areano", param.getAreano());
        }
        query.setFirstResult((param.getPageNo() - 1)*param.getPageSize());
        query.setMaxResults(param.getPageSize());
        query.unwrap(NativeQueryImpl.class).setResultTransformer(Transformers.aliasToBean(TAccdtlDTO.class));
        List<TAccdtlDTO> list = query.getResultList();
        BigInteger count = (BigInteger) countQuery.getSingleResult();
        return new PageResult<>(count.longValue(), list);
    }
}
