package com.supwisdom.dlpay.water.service.impl;

import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.water.bean.RegionSearchBean;
import com.supwisdom.dlpay.water.dao.AreaDao;
import com.supwisdom.dlpay.water.domain.TArea;
import com.supwisdom.dlpay.water.service.AreaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class AreaServiceImpl implements AreaService {

    @Autowired
    private AreaDao regionDao;

    /**
     * 根据父区域id查询区域列表
     *
     * @param param
     * @return
     */
    @Override
    public PageResult<TArea> queryAreasByParentId(RegionSearchBean param) {
        Pageable pageable = PageRequest.of(param.getPageNo() - 1, param.getPageSize());
        Page<TArea> page = regionDao.findByAvailableAndParentIdOrderByAreano(1, param.getParentId(), pageable);
        setParentArea(page);
        PageResult<TArea> result = new PageResult<>(page);
        List<TArea> data = result.getData();
        if (param.getPageNo() == 1) {
            Optional<TArea> optional = regionDao.findByAvailableAndAreano(1, param.getParentId());
            if (optional.isPresent()) {
                regionDao.findByAvailableAndAreano(1,optional.get().getParentId()).ifPresent(
                        parentArea -> optional.get().setParentName(parentArea.getAreaName())
                );
                data = new ArrayList<>(data);
                data.add(0, optional.get());
                result.setData(data);
            }
        }
        return result;
    }

    public List<Map<String, Object>> getAreaTree(List<TArea> regions, Integer parentId) {
        List<Map<String, Object>> list = new ArrayList<>(0);
        for (TArea region : regions) {
            if (parentId.equals(region.getParentId())) {
                Map<String, Object> map = new HashMap<>(0);
                map.put("title", region.getAreaName());
                map.put("id", region.getAreano());
                map.put("children", getAreaTree(regions, region.getAreano()));
                list.add(map);
            }
        }
        return list;
    }

    public List<TArea> queryAllAreas() {
        List<TArea> regions = regionDao.findAllByAvailableOrderByAreano(1);
        return regions.size() != 0 ? regions : null;
    }

    @Override
    public List<TArea> queryAllNotFLevelArea() {
        List<TArea> regions = regionDao.findByAvailableAndLevelNot(1, 1);
        return regions.size() != 0 ? regions : null;
    }

    @Override
    public PageResult<TArea> queryAreasBySearchKey(RegionSearchBean param) {
        Pageable pageable = PageRequest.of(param.getPageNo() - 1, param.getPageSize());
        Page<TArea> page;
        if (!StringUtil.isEmpty(param.getSearchKey())) {
            page = regionDao.findAllByAvailableAndAreaNameContainingOrderByAreano(1, param.getSearchKey().trim(), pageable);
        } else {
            page = regionDao.findAllByAvailableOrderByAreano(1, pageable);
        }
        setParentArea(page);
        return new PageResult<>(page);
    }

    @Override
    public boolean saveArea(TArea region) {
        if (region.getParentId() == 0) {
            region.setLevel(1);
        } else {
            Optional<TArea> optional = regionDao.findByAvailableAndAreano(1, region.getParentId());
            if (optional.isPresent()) {
                region.setLevel(optional.get().getLevel() + 1);
            } else {
                return false;
            }
        }
        region.setAvailable(1);
        regionDao.save(region);
        return true;
    }

    public boolean updateArea(TArea region) {
        Optional<TArea> optional = regionDao.findByAvailableAndAreano(1, region.getAreano());
        if (optional.isPresent()) {
            TArea oldRegion = optional.get();
            oldRegion.setAreaName(region.getAreaName());
            oldRegion.setAddress(region.getAddress());
            oldRegion.setRemarks(region.getRemarks());
            regionDao.save(oldRegion);
            return true;
        }
        return false;
    }

    @Override
    public boolean checkAreaName(TArea region) {
        if (region.getAreano() == null) {
            return regionDao.findAllByAvailableAndAreaName(1, region.getAreaName()) == null;
        } else {
            return regionDao.findByAvailableAndAreaNameAndAreanoNot(1,
                    region.getAreaName(),
                    region.getAreano()) == null;
        }
    }

    @Override
    public boolean deleteArea(Integer regino) {
        Optional<TArea> optional = regionDao.findByAvailableAndAreano(1, regino);
        if (optional.isPresent()) {
            TArea region = optional.get();
            region.setAvailable(0);
            regionDao.save(region);
            return true;
        }
        return false;
    }

    @Override
    public boolean existSubArea(Integer regino) {
        List<TArea> subRegion = regionDao.findByAvailableAndParentId(1, regino);
        return subRegion != null && subRegion.size() != 0;
    }

    @Override
    public PageResult<TArea> queryAreaByAreaNo(Integer areano) {
        Pageable pageable = PageRequest.of(0,1);
        Page<TArea> page = regionDao.findByAvailableAndAreano(1, areano, pageable);
        setParentArea(page);
        return new PageResult<>(page);
    }

    @Override
    public TArea findByAreaNo(Integer areano) {
        return regionDao.findByAvailableAndAreano(1, areano).orElse(null);
    }

    private void setParentArea(Page<TArea> page) {
        page.get().forEach(area -> {
            Optional<TArea> optional = regionDao.findByAvailableAndAreano(1, area.getParentId());
            optional.ifPresent(parentArea -> area.setParentName(parentArea.getAreaName()));
        });
    }
}
