package com.supwisdom.dlpay

import io.lettuce.core.ReadFrom
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.autoconfigure.SpringBootApplication
import org.springframework.boot.autoconfigure.data.redis.RedisProperties
import org.springframework.boot.runApplication
import org.springframework.cache.annotation.EnableCaching
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import org.springframework.data.redis.connection.RedisConnectionFactory
import org.springframework.data.redis.connection.RedisPassword
import org.springframework.data.redis.connection.RedisStandaloneConfiguration
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory
import org.springframework.data.redis.core.RedisTemplate
import org.springframework.data.redis.repository.configuration.EnableRedisRepositories
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer
import org.springframework.data.redis.serializer.StringRedisSerializer
import org.springframework.scheduling.annotation.EnableScheduling


@Configuration
@EnableScheduling
@EnableRedisRepositories
class AppConfig {

    @Autowired
    private lateinit var redisProperties: RedisProperties

    @Bean
    fun redisConnectionFactory(): RedisConnectionFactory {
        val clientConfig = LettuceClientConfiguration.builder()
                .readFrom(ReadFrom.SLAVE_PREFERRED)
                .build()
        val serverConfig = RedisStandaloneConfiguration(redisProperties.host, redisProperties.port)
        if (redisProperties.password.isNotEmpty()) {
            serverConfig.password = RedisPassword.of(redisProperties.password)
        }
        serverConfig.database = redisProperties.database

        return LettuceConnectionFactory(serverConfig, clientConfig)
    }
}

@Configuration
class HttpSessionConfig {
    @Bean
    fun sessionRedisTemplate(
            connectionFactory: RedisConnectionFactory): RedisTemplate<Any, Any> {
        val template = RedisTemplate<Any, Any>()
        template.keySerializer = StringRedisSerializer()
        template.hashKeySerializer = StringRedisSerializer()

        template.setDefaultSerializer(GenericJackson2JsonRedisSerializer())
        template.setConnectionFactory(connectionFactory)
        return template
    }
}


@SpringBootApplication
@EnableScheduling
@EnableCaching
class WaterManagerApplication

fun main(args: Array<String>) {
    runApplication<WaterManagerApplication>(*args)
}
