package com.supwisdom.dlpay.api.bean

import com.supwisdom.dlpay.exception.RequestParamCheckException
import com.supwisdom.dlpay.framework.util.*
import com.supwisdom.dlpay.util.ConstantUtil

// ============================ USER ============================ //
class OpenUserParam : APIRequestParam() {
    @Sign
    var uid: String = ""    //第三方用户ID,必传
    @Sign
    var name: String = ""   //必传
    @Sign
    var sex: String? = null
    @Sign
    var idtype: String = "" //必传
    @Sign
    var idno: String = ""   //必传
    @Sign
    var mobile: String? = null
    @Sign
    var tel: String? = null
    @Sign
    var email: String? = null
    @Sign
    var address: String? = null
    @Sign
    var zipcode: String? = null

    override fun checkParam(): Boolean {
        if (StringUtil.isEmpty(uid)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "用户唯一号不能为空")
        if (StringUtil.isEmpty(name)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "姓名不能为空")
        if (!StringUtil.isEmpty(sex) && ConstantUtil.SEX_MALE != sex && ConstantUtil.SEX_FEMALE != sex) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "性别非法[male|female]")
        if (StringUtil.isEmpty(idtype) || !ConstantUtil.IDTYPE_DICTS.contains(idtype)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "证件类型非法")
        if (StringUtil.isEmpty(idno) || !StringUtil.isCharAndNum(idno)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "证件号不能为空，且仅支持数字和字母")
        if (ConstantUtil.IDTYPE_IDENTITY == idtype && !StringUtil.isIdentity(idno)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "身份证格式错误")
        if (!StringUtil.isEmpty(mobile) && !StringUtil.isMobile(mobile)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "手机号格式错误")
        if (!StringUtil.isEmpty(email) && !StringUtil.isEmail(email)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "邮箱格式错误")

        return true
    }
}

class QueryUserParam : APIRequestParam() {
    @Sign
    var userid: String? = null  // 用户ID二选一 (两者都传取userid)
    @Sign
    var uid: String? = null    // 用户ID二选一

    override fun checkParam(): Boolean {
        if (StringUtil.isEmpty(userid) && StringUtil.isEmpty(uid)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "用户唯一号不能为空")

        return true
    }
}

class ModifyUserParam : APIRequestParam() {
    @Sign
    var userid: String? = null  // 用户ID二选一 (两者都传取userid)
    @Sign
    var uid: String? = null    // 用户ID二选一
    @Sign
    var name: String? = null
    @Sign
    var sex: String? = null
    @Sign
    var idtype: String? = null
    @Sign
    var idno: String? = null
    @Sign
    var mobile: String? = null
    @Sign
    var tel: String? = null
    @Sign
    var email: String? = null
    @Sign
    var address: String? = null
    @Sign
    var zipcode: String? = null

    override fun checkParam(): Boolean {
        if (StringUtil.isEmpty(userid) && StringUtil.isEmpty(uid)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "用户唯一号不能为空")
        if (!StringUtil.isEmpty(sex) && ConstantUtil.SEX_MALE != sex && ConstantUtil.SEX_FEMALE != sex) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "性别非法[male|female]")
        if (!StringUtil.isEmpty(idtype) && !ConstantUtil.IDTYPE_DICTS.contains(idtype)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "证件类型非法")
        if (!StringUtil.isEmpty(idno) && !StringUtil.isCharAndNum(idno)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "证件号不能为空，且仅支持数字和字母")
        if (!StringUtil.isEmpty(idno) && StringUtil.isEmpty(idtype)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "证件号不能为空时，请指定证件类型")
        if (!StringUtil.isEmpty(idno) && ConstantUtil.IDTYPE_IDENTITY == idtype && !StringUtil.isIdentity(idno)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "身份证格式错误")
        if (!StringUtil.isEmpty(mobile) && !StringUtil.isMobile(mobile)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "手机号格式错误")
        if (!StringUtil.isEmpty(email) && !StringUtil.isEmail(email)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "邮箱格式错误")

        return true
    }
}


// ============================ SHOP ============================ //
class OpenShopParam : APIRequestParam() {
    @Sign
    var shopUniqueId: String = "" //必传
    @Sign
    var shoptype: Int = 1
    @Sign
    var fshopid: Int? = null
    @Sign
    var shopname: String = "" //必传
    @Sign
    var contactman: String? = null
    @Sign
    var idtype: String? = null
    @Sign
    var idno: String? = null
    @Sign
    var mobile: String? = null
    @Sign
    var email: String? = null
    @Sign
    var address: String? = null
    @Sign
    var zipcode: String? = null

    override fun checkParam(): Boolean {
        if (StringUtil.isEmpty(shopUniqueId)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "商户唯一号不能为空")
        if (ConstantUtil.SHOPTYPE_GROUP != shoptype && ConstantUtil.SHOPTYPE_LEAF != shoptype) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "请指定商户类型")
        if (StringUtil.isEmpty(shopname)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "商户名称不能为空")
        if (!StringUtil.isEmpty(idtype) && !ConstantUtil.IDTYPE_DICTS.contains(idtype)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "证件类型非法")
        if (!StringUtil.isEmpty(idno) && !StringUtil.isCharAndNum(idno)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "证件号不能为空，且仅支持数字和字母")
        if (!StringUtil.isEmpty(idno) && StringUtil.isEmpty(idtype)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "证件号不能为空时，请指定证件类型")
        if (!StringUtil.isEmpty(mobile) && !StringUtil.isMobile(mobile)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "手机号格式错误")
        if (!StringUtil.isEmpty(email) && !StringUtil.isEmail(email)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "邮箱格式错误")

        return true
    }
}

class QueryShopParam : APIRequestParam() {
    @Sign
    var shopid: Int? = null  //注册时返回的shopid
    @Sign
    var shopaccno: String? = null  //注册时返回的shopaccno
    @Sign
    var shopUniqueId: String? = null //注册传的商户唯一号

    override fun checkParam(): Boolean {
        if (StringUtil.isEmpty(shopUniqueId) && null == shopid && StringUtil.isEmpty(shopaccno)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "商户唯一标志不能为空")

        return true
    }
}


// ============================ CONSUME ============================ //
class ConsumeFeetype {
    var feetype: String = ""
    var amount: Int = 0

    override fun toString(): String {
        return "{feetype='$feetype', amount=$amount}"
    }
}

class QueryDtlResultParam : APIRequestParam() {
    @Sign
    var refno: String? = null //二选一
    @Sign
    var billno: String? = null //二选一 (cobillno+shopaccno） 传billno时，shopaccno必传
    @Sign
    var shopaccno: String? = null

    override fun checkParam(): Boolean {
        if (StringUtil.isEmpty(refno) && (StringUtil.isEmpty(billno) || StringUtil.isEmpty(shopaccno))) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "流水唯一号不能为空")

        return true
    }
}


class YktCardPayinitParam : APIRequestParam() {
    @Sign
    var uid: String? = null //未注册，可能不传
    @Sign
    var shopaccno: String = "" //必传
    @Sign
    var amount: Int = 0 //必传

    var feelist: List<ConsumeFeetype>? = null //TODO: 怎么拼接签名字符串？？
    @Sign
    var billno: String = "" //必传
    @Sign
    var transdate: String = "" //必传
    @Sign
    var transtime: String = "" //必传
    @Sign
    var stuempno: String = "" //必传
    @Sign
    var yktshopid: String? = null
    @Sign
    var devphyid: String? = null

    override fun checkParam(): Boolean {

        if (StringUtil.isEmpty(shopaccno)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "请指定交易商户")
        if (amount <= 0) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "交易金额必须大于零")
        if (StringUtil.isEmpty(billno)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "对接系统唯一订单号不能为空")
        if (!DateUtil.checkDatetimeValid(transdate, DateUtil.DATE_FMT)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "交易日期错误[yyyyMMdd]")
        if (!DateUtil.checkDatetimeValid(transtime, DateUtil.TIME_FMT)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "交易时间错误[HHmmss]")
        if (StringUtil.isEmpty(stuempno)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "一卡通唯一号不能为空")
        if (!StringUtil.isEmpty(yktshopid) && !NumberUtil.isDigits(yktshopid)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "一卡通商户号非整数")

        return true
    }
}

class ConfirmAccParam : APIRequestParam() {
    @Sign
    var accdate: String = ""
    @Sign
    var accstatus: String = ""
    @Sign
    var refno: String = ""
    @Sign
    var billno: String = ""

    override fun checkParam(): Boolean {
        if (StringUtil.isEmpty(accdate)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "入账日期不能为空")
        if (StringUtil.isEmpty(accstatus)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "入账确认状态不能为空")
        if (StringUtil.isEmpty(refno)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "入账确认流水号不能为空")
        if (StringUtil.isEmpty(billno)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "本地流水号不能为空")
        return true
    }
}

class InitAccParam : APIRequestParam() {
    @Sign
    var refno: String = ""
    @Sign
    var billno: String = ""

    override fun checkParam(): Boolean {
        if (StringUtil.isEmpty(refno)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "入账确认流水号不能为空")
        if (StringUtil.isEmpty(billno)) throw RequestParamCheckException(TradeErrorCode.REQUEST_PARAM_ERROR, "本地流水号不能为空")
        return true
    }
}




