package com.supwisdom.dlpay.framework

import com.supwisdom.dlpay.framework.tenant.TenantInterceptor
import mu.KotlinLogging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.Configuration
import org.springframework.web.servlet.config.annotation.InterceptorRegistry
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer
import javax.annotation.PostConstruct


//@Order(1)
//@WebFilter(filterName = "multi_tenant_filter", urlPatterns = ["/*"])
//class TenantNameFilter : Filter {
//    override fun doFilter(request: ServletRequest, response: ServletResponse, chain: FilterChain) {
//        if (request is HttpServletRequest) {
//            request.getHeader(Constants.HEADER_TETANTID)?.also {
//                // set tanent datasource
//                TenantContext.setTenantSchema(it)
//            } ?: TenantContext.setTenantSchema("default")
//        }
//        chain.doFilter(request, response)
//    }
//}

@Configuration
class MultiTenantDatasourceConfiguration : WebMvcConfigurer {

    private val logger = KotlinLogging.logger { }
    @Autowired
    private lateinit var tenantInterceptor: TenantInterceptor

    @PostConstruct
    fun post() {
        logger.info("MultiTenantDatasourceConfiguration post constructor.")
    }

    override fun addInterceptors(registry: InterceptorRegistry) {
        logger.info("adding interceptor(s).")
        registry.addInterceptor(tenantInterceptor)
    }
}
