package com.supwisdom.dlpay.water

import com.supwisdom.dlpay.exception.RequestParamCheckException
import com.supwisdom.dlpay.framework.util.APIRequestParam
import com.supwisdom.dlpay.framework.util.DateUtil
import com.supwisdom.dlpay.framework.util.Sign
import com.supwisdom.dlpay.framework.util.TradeErrorCode

class DeviceLoginParam : APIRequestParam() {
    @Sign
    var deviceno: String = ""

    @Sign
    var termdate: String = ""

    @Sign
    var termtime: String = ""

    @Sign
    var hwVer: String = ""

    override fun checkParam(): Boolean {
        if (deviceno.length != 8 || deviceno.any { it !in '0'..'9' }) {
            throw RequestParamCheckException(TradeErrorCode.INPUT_DATA_ERROR, "设备ID号长度不符")
        }

        if (!DateUtil.checkDatetimeValid(termdate, DateUtil.DATE_FMT)
                || !DateUtil.checkDatetimeValid(termtime, DateUtil.TIME_FMT)) {
            throw RequestParamCheckException(TradeErrorCode.INPUT_DATA_ERROR, "设备日期时间错误")
        }
        return true
    }
}

class DeviceLineCheckParam : APIRequestParam() {
    @Sign
    var deviceno: String = ""

    @Sign
    var termdate: String = ""

    @Sign
    var termtime: String = ""

    @Sign
    var offlineRecordCount: Int = 0

    override fun checkParam(): Boolean {
        if (deviceno.length != 8 || deviceno.any { it !in '0'..'9' }) {
            throw RequestParamCheckException(TradeErrorCode.INPUT_DATA_ERROR, "设备ID号长度不符")
        }

        if (!DateUtil.checkDatetimeValid(termdate, DateUtil.DATE_FMT)
                || !DateUtil.checkDatetimeValid(termtime, DateUtil.TIME_FMT)) {
            throw RequestParamCheckException(TradeErrorCode.INPUT_DATA_ERROR, "设备日期时间错误")
        }
        return true
    }

}

class CardPayRequest : APIRequestParam() {
    @Sign
    var deviceno: String = ""

    @Sign
    var termdate: String = ""

    @Sign
    var termtime: String = ""

    @Sign
    var citizenCardno: String = ""

    @Sign
    var cardphyid: String = ""

    override fun checkParam(): Boolean {
        if (deviceno.length != 8 || deviceno.any { it !in '0'..'9' }) {
            throw RequestParamCheckException(TradeErrorCode.INPUT_DATA_ERROR, "设备ID号长度不符")
        }
        if (citizenCardno.length != 8 || citizenCardno.any { it !in '0'..'9' }) {
            throw RequestParamCheckException(TradeErrorCode.INPUT_DATA_ERROR, "市民卡号长度不符")
        }
        if (!DateUtil.checkDatetimeValid(termdate, DateUtil.DATE_FMT)
                || !DateUtil.checkDatetimeValid(termtime, DateUtil.TIME_FMT)) {
            throw RequestParamCheckException(TradeErrorCode.INPUT_DATA_ERROR, "设备日期时间错误")
        }

        if (citizenCardno.isEmpty()) {
            throw RequestParamCheckException(TradeErrorCode.INPUT_DATA_ERROR, "市民卡号长度错误")
        }
        if (cardphyid.isEmpty()) {
            throw RequestParamCheckException(TradeErrorCode.INPUT_DATA_ERROR, "物理卡号长度错误")
        }
        return true
    }
}

class QrcodePayRequest : APIRequestParam() {
    @Sign
    var deviceno: String = ""

    @Sign
    var termdate: String = ""

    @Sign
    var termtime: String = ""

    override fun checkParam(): Boolean {
        if (deviceno.length != 8 || deviceno.any { it !in '0'..'9' }) {
            throw RequestParamCheckException(TradeErrorCode.INPUT_DATA_ERROR, "设备ID号长度不符")
        }

        if (!DateUtil.checkDatetimeValid(termdate, DateUtil.DATE_FMT)
                || !DateUtil.checkDatetimeValid(termtime, DateUtil.TIME_FMT)) {
            throw RequestParamCheckException(TradeErrorCode.INPUT_DATA_ERROR, "设备日期时间错误")
        }

        return true
    }
}

class QrcodeQueryRequest : APIRequestParam() {
    @Sign
    var deviceno: String = ""

    @Sign
    var cobillno: Int = 0


    override fun checkParam(): Boolean {
        if (deviceno.length != 8 || deviceno.any { it !in '0'..'9' }) {
            throw RequestParamCheckException(TradeErrorCode.INPUT_DATA_ERROR, "设备ID号长度不符")
        }
        return true
    }
}

class UploadRecordRequest : APIRequestParam() {
    @Sign
    var deviceno: String = ""

    @Sign
    var transdate: String = ""

    @Sign
    var transtime: String = ""

    @Sign
    var cobillno: Int = 0

    @Sign
    var amount: Int = 0

    @Sign
    var flowsensors: Int = 0

    @Sign
    var transtatus: String = ""

    override fun checkParam(): Boolean {
        if (deviceno.length != 8 || deviceno.any { it !in '0'..'9' }) {
            throw RequestParamCheckException(TradeErrorCode.INPUT_DATA_ERROR, "设备ID号长度不符")
        }

        if (!DateUtil.checkDatetimeValid(transdate, DateUtil.DATE_FMT)
                || !DateUtil.checkDatetimeValid(transtime, DateUtil.TIME_FMT)) {
            throw RequestParamCheckException(TradeErrorCode.INPUT_DATA_ERROR, "设备日期时间错误")
        }
        return true
    }
}

class StartWaterRequest : APIRequestParam() {

    @Sign
    var cobillno: Int = 0

    override fun checkParam(): Boolean {
        return true
    }
}

class AccdtlParam : APIRequestParam() {

    @Sign
    var deviceno: String = ""

    @Sign
    var cobillno: Int = 0

    @Sign
    var transdate: String = ""

    @Sign
    var transtime: String = ""

    @Sign
    var amount: Double = 0.0

    @Sign
    var flowsensors: Int = 0

    @Sign
    var userid: String = ""

    @Sign
    var citizenCardno: String = ""

    @Sign
    var mode: String = ""

    @Sign
    var cardPhyId: String = ""

    override fun checkParam(): Boolean {
        if (deviceno.length != 8 || deviceno.any { it !in '0'..'9' }) {
            throw RequestParamCheckException(TradeErrorCode.INPUT_DATA_ERROR, "设备ID号长度不符")
        }
        if (!DateUtil.checkDatetimeValid(transdate, DateUtil.DATE_FMT)
                || !DateUtil.checkDatetimeValid(transtime, DateUtil.TIME_FMT)) {
            throw RequestParamCheckException(TradeErrorCode.INPUT_DATA_ERROR, "交易日期时间错误")
        }
        if (citizenCardno.isEmpty()) {
            throw RequestParamCheckException(TradeErrorCode.INPUT_DATA_ERROR, "市民卡号长度错误")
        }
        if (cardPhyId.isEmpty()) {
            throw RequestParamCheckException(TradeErrorCode.INPUT_DATA_ERROR, "物理卡号长度错误")
        }
        if (cobillno==0) {
            throw RequestParamCheckException(TradeErrorCode.INPUT_DATA_ERROR, "采集流水号不能为空")
        }
        return true
    }
}