package com.supwisdom.dlpay.water

import mu.KotlinLogging
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import org.springframework.scheduling.annotation.AsyncConfigurer
import org.springframework.scheduling.annotation.EnableAsync
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor
import java.lang.reflect.Method
import java.util.concurrent.Executor

@Configuration
@EnableAsync
class SpringAsyncConfig : AsyncConfigurer {
    @Bean(value = ["waterPay"])
    fun threadPoolExecutor(): Executor {
        return ThreadPoolTaskExecutor().apply {
            corePoolSize = 5
            maxPoolSize = 10
            setWaitForTasksToCompleteOnShutdown(true)
        }
    }

    override fun getAsyncUncaughtExceptionHandler(): AsyncUncaughtExceptionHandler? {
        return MyAsyncUncaughtExceptionHandler()
    }
}

class MyAsyncUncaughtExceptionHandler : AsyncUncaughtExceptionHandler {
    private val logger = KotlinLogging.logger { }
    override fun handleUncaughtException(ex: Throwable, method: Method, vararg params: Any?) {
        ex.printStackTrace()
        logger.error { "Async Task execute error: <${method.name}>, exception <${ex.message}>" }
    }
}
