package com.supwisdom.dlpay.water

import com.supwisdom.dlpay.paysdk.ApiLoginHelper
import com.supwisdom.dlpay.paysdk.proxy.ApiLoginProxy
import com.supwisdom.dlpay.water.pay.WaterPayAsyncTask
import com.supwisdom.dlpay.water.service.CollectdtlService
import mu.KotlinLogging
import net.javacrumbs.shedlock.core.SchedulerLock
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.scheduling.annotation.Scheduled
import org.springframework.stereotype.Component

@Component
class CollectdtlQueryResultSchedulerTask {

    private val logger = KotlinLogging.logger { }

    @Autowired
    private lateinit var collectdtlService: CollectdtlService

    @Autowired
    private lateinit var waterPayAsyncTask: WaterPayAsyncTask

    @Scheduled(cron = "0 */10 * * * ?")
    @SchedulerLock(name = "dealCollectdtlAccountEntry", lockAtMostForString = "PT10M")
    fun queryCollectdtlResult() {
        val collectdtlList = collectdtlService.queryTransdtlNotEntry()
        if (null == collectdtlList || 0 == collectdtlList.size) {
            return
        }
        for (collectdtl in collectdtlList) {
            waterPayAsyncTask.waterPay(collectdtl.cobillno)
        }
    }
}

@Component
class GenerateCountdtlSchedulerTask{
    @Autowired
    private lateinit var collectdtlService: CollectdtlService

    @Scheduled(cron = "0 0 1 * * ?")
    @SchedulerLock(name = "generateCountdtl",lockAtMostForString = "PT10M")
    fun generateCountdtl() {
        collectdtlService.generateCountdtl()
    }
}

@Component
class RefreshJwtSchedulerTask {

    private val logger = KotlinLogging.logger { }

    @Autowired
    private lateinit var apiLoginProxy: ApiLoginProxy

    @Scheduled(cron = "0 */20 * * * ?")
    @SchedulerLock(name = "refreshJwt", lockAtMostForString = "PT10M")
    fun refreshJwt() {
        val loginHelper = ApiLoginHelper(apiLoginProxy)
        loginHelper.refresh()
    }
}