// pages/register/register.js
Page({

  /**
   * 页面的初始数据
   */
  data: {
    phone: '',
    code: '',
    sendTime: '获取验证码',
    sendColor: 'rgb(124, 255, 112)',
    snsMsgWait: 30,
    smsFlag: true,
    privacyCheck:''
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {

  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  },
  showPolicy: function() {
    wx.navigateTo({
      url: '../policy/policy',
    })
  },
  setPhone: function(e) {
    this.setData({
      phone: e.detail.value
    })
  },
  setCode: function(e) {
    this.setData({
      code: e.detail.value
    })
  },
  checkboxChange:function(e){
    console.log(e.detail.value);
    this.setData({
      privacyCheck: e.detail.value
    })

  },
  doRegister: function() {
    var phone = this.data.phone;
    var code=this.data.code;
    if (wx.$isEmpty(phone)||wx.$isEmpty(code)) {
      return;
    }
    var agree =this.data.privacyCheck;
    if (wx.$isEmpty(agree)) {
      wx.showModal({
        title: '提示',
        content: '请同意用户协议与隐私条款',
      })
      return;
    }
    wx.showLoading({
      title: '加载中',
    })
    var name,platform,version;
    wx.getSystemInfo({
      success: function(res) {
        name=res.model;
        platform=res.platform;
        version=res.version

      },
    })
    
    var param = {
      "phone": phone,
      "code": code,
      "platform": name + "," + platform + "," + version,
      "uuid": '123456'
    }
    
    console.log(param);
    wx.$doPost('/i/checkcode',param, function(ok, ret) {
      if (ok) {
        wx.hideLoading();
        console.log(ret)
        if (ret.data.code == 200) {
          wx.setStorageSync("phone", phone);
          wx.setStorageSync("uid", ret.data.uid);
          wx.setStorageSync("code", ret.data.randcode);
          wx.removeStorageSync('name');
    
          wx.navigateTo({
            url: '../pwdset/pwdset',
          })
        } else {
          wx.showModal({
            title: '错误',
            content: ret.data.msg,

            duration: 2000
          })
        }
      } else {
        wx.hideLoading();
        wx.showModal({
          title: '错误',
          content: "请求失败了，请稍后再试",

          duration: 2000
        })
      }
    })

  },
  getCode: function() {
    var phone = this.data.phone;
    if (wx.$isEmpty(phone)) {
      return;
    }
    if (false == this.data.smsFlag) {
      return;
    }

    wx.$doCountdown(this);
    
    var param = {
      "phone": phone
    }
    wx.$doPost('/i/code', param, function(ok, ret) {
      console.log(ret.data);
      if (ok) {
        if (ret.data.code == 200) {
        } else {
          wx.showModal({
            title: '错误',
            content: ret.data.msg,

            duration: 2000
          })
        }
      } else {
        wx.showModal({
          title: '错误',
          content: "请求失败了" + ret.status + "，请稍后再试",
          duration: 2000
        })
      }
    })
  }
})