-- 10.1.init.sql

/*
将 paas.example.com 替换为 paas.学校域名.edu.cn
*/

-- 以下脚本为可选操作

/*
 * 若部署了流程平台、门户的产品
 * 可初始化云平台下的相关菜单数据
 */

use admin_center;

-- flow
-- 如果部署，流程平台，请处理

insert into TB_MGT_ROUTE (ID, DELETED, CODE, NAME, STATUS, PATH_PREFIX, URL, STRIP_PREFIX) 
values ('50', 0, 'flow-api', '管理门户 - 流程接口', '1', '/api/v1/flow-release', 'http://formflow-formflow-svc.formflow.svc.cluster.local:8080/formflow', 1);

commit;

/*
update TB_MGT_ROUTE 
set 
  URL='http://formflow.paas.example.com' 
where ID='50';  -- todo, modify

commit;
*/

insert into TB_MGT_ROLE (ID, DELETED, CODE, NAME, MEMO, STATUS) 
values ('50', 0, 'flow-admin', '流程表单管理员', '', '1');
insert into TB_MGT_ROLE (ID, DELETED, CODE, NAME, MEMO, STATUS) 
values ('51', 0, 'flow-biz', '流程操作员', '业务、应用组、应用相关管理的操作人员', '1');

commit;


update TB_MGT_PERMISSION
  set LFT = LFT+10
where LFT>=82
;

update TB_MGT_PERMISSION
  set RGT = RGT+10
where RGT>=82
;


insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, ICON, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('50000', 0, 'formflow-manager', '流程管理', '1', '2', '', '/', '1', '1', 50000, 1, 82, 91);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, ICON, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('50100', 0, 'formflow', '流程表单', '1', '2', 'su-icon-liuchengbiaodan', '/formflow', '1', '50000', 50100, 2, 83, 84);
insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, ICON, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('50200', 0, 'workbench', '工作台', '1', '2', 'su-icon-gongzuotai', '/formflow/workbench', '1', '50000', 50200, 2, 85, 86);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, ICON, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('50300', 0, 'instanceManage', '实例管理', '1', '2', 'su-icon-shiliguanli', '/formflow/instanceManage', '1', '50000', 50300, 2, 87, 88);
insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, ICON, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('50400', 0, 'agent', '代理代办', '0', '2', 'su-icon-dailidaiban', '/formflow/agent', '1', '50000', 50400, 2, 89, 90);

commit;


insert into TB_MGT_ROLE_PERMISSION (ID, DELETED, ROLE_ID, PERMISSION_ID) 

select CONCAT('1_', ID) as ID, 0 as DELETED, '1' as ROLE_ID, ID as PERMISSION_ID 
from TB_MGT_PERMISSION
where (ID like '5____' or ID='1')
  and CONCAT('1_', ID) not in (select ID from TB_MGT_ROLE_PERMISSION)
;

insert into TB_MGT_ROLE_PERMISSION (ID, DELETED, ROLE_ID, PERMISSION_ID) 

select CONCAT('50_', ID) as ID, 0 as DELETED, '50' as ROLE_ID, ID as PERMISSION_ID 
from TB_MGT_PERMISSION
where (ID like '5____' or ID='1')
  and CONCAT('50_', ID) not in (select ID from TB_MGT_ROLE_PERMISSION)
;

commit;


-- 更新 admin-platform 下菜单的访问域

update TB_MGT_PERMISSION
set 
  ORIGIN='http://admin-platform.paas.example.com'
where LFT >= 82
  and RGT <= 91
;

commit;
