# readme.md


## 使用 openssl 生成 公私钥


1. 生成私钥 App Private Key

必须为 RSA2(SHA256)

```bash
openssl genrsa -out jwt_private_key.pem 1024
```

2. 将私钥转换为 PKCS8 格式

```bash
openssl pkcs8 -topk8 -inform PEM -in jwt_private_key.pem -outform PEM -nocrypt -out jwt_private_key_pkcs8.pem
```

3. 导出公钥 App Public Key

```bash
openssl rsa -in jwt_private_key.pem -pubout -out jwt_public_key.pem
```

4. 将 jwt_public_key.pem 中的内容，去除换行和空格，转成字符串。

处理前：
```language
-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDBr5wUHXSlLSFU17T4wDX8ehAI
2nnZxCc2SnpgfNwuR3jvViSVyr+Pd6JJEeMcl397qKjWqFD/CRlUSB/UEPQRxxbB
XVlXRB289KE9xteDk04bU17ILgX8Vz/7LFRLn2CpaCSICfWENhoMRJm7xIAodrI3
FugvRF/6jdTQis2LcQIDAQAB
-----END PUBLIC KEY-----
```
处理后：
```language
-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDBr5wUHXSlLSFU17T4wDX8ehAI2nnZxCc2SnpgfNwuR3jvViSVyr+Pd6JJEeMcl397qKjWqFD/CRlUSB/UEPQRxxbBXVlXRB289KE9xteDk04bU17ILgX8Vz/7LFRLn2CpaCSICfWENhoMRJm7xIAodrI3FugvRF/6jdTQis2LcQIDAQAB
-----END PUBLIC KEY-----
```

4. 将 jwt_private_key_pkcs8.pem 中的内容，去除换行和空格，转成字符串。

处理前：
```language
-----BEGIN PRIVATE KEY-----
MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAMGvnBQddKUtIVTX
tPjANfx6EAjaednEJzZKemB83C5HeO9WJJXKv493okkR4xyXf3uoqNaoUP8JGVRI
H9QQ9BHHFsFdWVdEHbz0oT3G14OTThtTXsguBfxXP/ssVEufYKloJIgJ9YQ2GgxE
mbvEgCh2sjcW6C9EX/qN1NCKzYtxAgMBAAECgYBKBSjq7w7jCUpRuFYrMpnvMV7r
Y0NqG/K4ZuI5+b3T2fC31v4IWQG4fIoCztky1hscUSqlTpIVxY5ujVnMm+YKMXs+
qW2zyUdvoqUbFNAZstYatg6FQ7QlwXMDnIzlq6w5lEofsO46+0kH/d9IX+cPN0nH
04J1UKwg0ugyjYVUAQJBAP8di+ECIJkVTbi96JWMCfK1eYdxwe+8DEd7kcW2P6qU
/0fxP6qExkbFqPWQbJVNvOKmH5tVW5oi4Q7vaT4MzJECQQDCW4kMG7a6yBKRWZ1/
hAixqumBv5FFCnL/yzqH6a5n8tb91vcQCwBGfu+YeQt8zVI56BTP4AJDF5KQu1vq
kcDhAkEA+YaHu2QeSDzrEShG5obbcBaKMK1WmEqg5AX8FZrleM5VRqOztvA5Ex3f
3ZgObJZlinYb8g2yE/fLk5UdpgBU0QJAFw+FU0p2g/L5QQXBCkBAR9RfoGV6dxam
TnNunnG7n9nQaI35Ao5LmhG1nAHAuy4hc311+rQ5kHxbh5Czd0GUAQJBALxZpqPZ
y7LrKmTbVLAdd0K1dQ3jWUsqk5HXwlxzrmmypn5ut41zwZQl0znyrv7XcfDZ6dqR
hh20uoiJ/Hfky6A=
-----END PRIVATE KEY-----
```
处理后：
```language
-----BEGIN PRIVATE KEY-----
MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAMGvnBQddKUtIVTXtPjANfx6EAjaednEJzZKemB83C5HeO9WJJXKv493okkR4xyXf3uoqNaoUP8JGVRIH9QQ9BHHFsFdWVdEHbz0oT3G14OTThtTXsguBfxXP/ssVEufYKloJIgJ9YQ2GgxEmbvEgCh2sjcW6C9EX/qN1NCKzYtxAgMBAAECgYBKBSjq7w7jCUpRuFYrMpnvMV7rY0NqG/K4ZuI5+b3T2fC31v4IWQG4fIoCztky1hscUSqlTpIVxY5ujVnMm+YKMXs+qW2zyUdvoqUbFNAZstYatg6FQ7QlwXMDnIzlq6w5lEofsO46+0kH/d9IX+cPN0nH04J1UKwg0ugyjYVUAQJBAP8di+ECIJkVTbi96JWMCfK1eYdxwe+8DEd7kcW2P6qU/0fxP6qExkbFqPWQbJVNvOKmH5tVW5oi4Q7vaT4MzJECQQDCW4kMG7a6yBKRWZ1/hAixqumBv5FFCnL/yzqH6a5n8tb91vcQCwBGfu+YeQt8zVI56BTP4AJDF5KQu1vqkcDhAkEA+YaHu2QeSDzrEShG5obbcBaKMK1WmEqg5AX8FZrleM5VRqOztvA5Ex3f3ZgObJZlinYb8g2yE/fLk5UdpgBU0QJAFw+FU0p2g/L5QQXBCkBAR9RfoGV6dxamTnNunnG7n9nQaI35Ao5LmhG1nAHAuy4hc311+rQ5kHxbh5Czd0GUAQJBALxZpqPZy7LrKmTbVLAdd0K1dQ3jWUsqk5HXwlxzrmmypn5ut41zwZQl0znyrv7XcfDZ6dqRhh20uoiJ/Hfky6A=
-----END PRIVATE KEY-----
```


5. （可选）将pem内容进行 base64 编码后，配置到k8s

echo -n '-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDzgNo1jsexpIahW50bbEFcJV6qzOnjjMBum4jMB/CgkJqZHxEh9u1yhdzfdHI+TJREy9RuoqumdRGpVA+YXOwHZnPUU/cHQQkITViPVPSvIHLKA7eqHbmb9FZdQZfFmadBm+AcVpQG+h4SuJgD5yAtye7oRLzxEGXZM+trt8HoFwIDAQAB
-----END PUBLIC KEY-----' |base64


echo -n '-----BEGIN PRIVATE KEY-----
MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAPOA2jWOx7GkhqFbnRtsQVwlXqrM6eOMwG6biMwH8KCQmpkfESH27XKF3N90cj5MlETL1G6iq6Z1EalUD5hc7Admc9RT9wdBCQhNWI9U9K8gcsoDt6oduZv0Vl1Bl8WZp0Gb4BxWlAb6HhK4mAPnIC3J7uhEvPEQZdkz62u3wegXAgMBAAECgYEA7mA8veOJsGjs9zd1ZKwki+11cGVrrjxTAbS3RW2cbcNB5RZZslNF/i/3mrUnRb+4AmU8EBalTS4b3RUSs0h8MZV9ObLazZg/c8GlLJeISuRWSuCG7ysvn4NS5ncCj5LW/0w6qKTtzIZqKdMbKfPl1xs+fPCaqlv7mpzIGUYGOKECQQD9125TlH6ftXoR5qaN6CLUuRpdpizjE59pmQMxgL/MQS45G9pUtTHfCZVDKgftqHFZEhL2ysrCbl7TFwHJ2wjHAkEA9ZLqvVPP4RLl78lt/OjLRliGDCeWkw5samzeveIsiaeWItsHzcGqipVw1zCaRRlY/hPs4uHSY0hWWV1+SGr2MQJAcgNdLnU4GovsdDXhAUQOwPUS/pUw/B1IMKnlYUqu2xM7q7Ly8bEg4UjwneY3AWvy3Urc8bRMNeBU/wMKbpvO6QJAVUuZQvdYbdmtidLR5BVLfXyD2rbpYtyQpYp490UWqR1PVX30QPAydv4e+m9ENhnuwhlTnx5Gf/uBGnsRwL9+EQJAcB6ptBg0drWmnpDC3HhFUSWaBVp6BAZic/YeC95pwynlcKScCTI+IY+wXKWRQwcqb2K+STaX4vhsTDLxDZaJAw==
-----END PRIVATE KEY-----' |base64
