# readme.md


## 使用 openssl 生成 公私钥


1. 生成私钥 App Private Key

必须为 RSA2(SHA256)

```bash
openssl genrsa -out jwt_private_key.pem 2048
```

2. 将私钥转换为 PKCS8 格式

```bash
openssl pkcs8 -topk8 -inform PEM -in jwt_private_key.pem -outform PEM -nocrypt -out jwt_private_key_pkcs8.pem
```

3. 导出公钥 App Public Key

```bash
openssl rsa -in jwt_private_key.pem -pubout -out jwt_public_key.pem
```

4. 将 jwt_public_key.pem 中的内容，去除换行和空格，转成字符串。

处理前：
```language
-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwow0APEh9F91vvtAzl7V
FmXRAOGhlo+22KX+rqC3ziGg4+yIk8evAL1T97XEuK1huqcAp+p4PIG2t/Rb3FBD
+vVJGoXKsyLCMUmT4Sy5/TRhb3TM0CHefvMZTSMwcVzKT07DtxyGgFZj9WsUYZWr
BUPcu0vD6s7m5Qe3qFJJWVeRX8NDnVAxySzrz4bI4+1qvtyey/uap3I6txxRxUlI
aMyTsD8pl63u14dD2FHRM6JY3tmdEpBEMWI91qmYbl9HkH/D6Xtumg0Hmzh06bdr
lO3YNscpr6iN2ug6yGNtAh4/ug4P4ZV9nxImcj8l8Pt3jio1O0IIpf4MUCMD+C7P
rQIDAQAB
-----END PUBLIC KEY-----
```
处理后：
```language
-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwow0APEh9F91vvtAzl7VFmXRAOGhlo+22KX+rqC3ziGg4+yIk8evAL1T97XEuK1huqcAp+p4PIG2t/Rb3FBD+vVJGoXKsyLCMUmT4Sy5/TRhb3TM0CHefvMZTSMwcVzKT07DtxyGgFZj9WsUYZWrBUPcu0vD6s7m5Qe3qFJJWVeRX8NDnVAxySzrz4bI4+1qvtyey/uap3I6txxRxUlIaMyTsD8pl63u14dD2FHRM6JY3tmdEpBEMWI91qmYbl9HkH/D6Xtumg0Hmzh06bdrlO3YNscpr6iN2ug6yGNtAh4/ug4P4ZV9nxImcj8l8Pt3jio1O0IIpf4MUCMD+C7PrQIDAQAB
-----END PUBLIC KEY-----
```

4. 将 jwt_private_key_pkcs8.pem 中的内容，去除换行和空格，转成字符串。

处理前：
```language
-----BEGIN PRIVATE KEY-----
MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDCjDQA8SH0X3W+
+0DOXtUWZdEA4aGWj7bYpf6uoLfOIaDj7IiTx68AvVP3tcS4rWG6pwCn6ng8gba3
9FvcUEP69UkahcqzIsIxSZPhLLn9NGFvdMzQId5+8xlNIzBxXMpPTsO3HIaAVmP1
axRhlasFQ9y7S8PqzublB7eoUklZV5Ffw0OdUDHJLOvPhsjj7Wq+3J7L+5qncjq3
HFHFSUhozJOwPymXre7Xh0PYUdEzolje2Z0SkEQxYj3WqZhuX0eQf8Ppe26aDQeb
OHTpt2uU7dg2xymvqI3a6DrIY20CHj+6Dg/hlX2fEiZyPyXw+3eOKjU7Qgil/gxQ
IwP4Ls+tAgMBAAECggEAaQOlTpza5z5gIKcfZEZsX5q2JvOkddE9sdRolXrLvMkK
P/39+0def9ey65OCjO2KQ2bCQ+Gc5YxfRQzySQpKp7yfqWFu+SNaD6DX4kRyYOtV
bQRvSin+ICi5D5pfG9IqooSxwLX1JHF9o4wZhFN17XGkRLWxG55zpE12JbXFQiPB
pck6hcMfx+r5wk7t4ret/8P/MDcyrPuUavJemd4D2jRrD7AmOGJDvElioFcOKA+V
S8oe/uBdpU8cbYJvct68fHOzG9IW3hdqYV18fhNtWqp9WeuUP+F2UMmOXbAtZ106
Zcd+V/jsse2G9KvGzmDA61ZGxzHUjt+JNIpN+V2HQQKBgQDkfYb8vIMc2yV0CM30
mAaPIapgpw8brYS8v+azQR/jjsuHFJ1CQJAih79y2gwdjKbDl0XByjj/qiHLTPcu
6dkuavdsV9MrlFfVqAXUMNDHrWEn5nMahlq3UZbflBqlavTr0gvEA8Da+ZXcRvWg
TP5+g5RFrKHJVOyQ+GzgDggQawKBgQDZ+IDRthf0UHvvZsoUbeb37Wut9jdjRgLJ
S1X4RtH+NPN23lvtTKJmUNfrFxiOfeVBfCXmGep0ibTqDVo0zBeHSu4BFM3BsICu
7xafmLafZxZqHcgWuF9keOCWjKN5fzub5xGqd2yge9hGN2zA2U9qp4mltGzeoZ/0
TuLuR59GRwKBgCGga7ZUVANyKQ/rn8vod8am0LlKvMl4/vj8UQp+gh/uSvvFR+OR
NuUuDznq5y+OHJjacXS0uzC9LB4MZLBtz/2p1mIGhth6C3cxNDJnQMKyPIMvwi7c
KQujoU2kMUu48vSlw/+EAeT4KFrzwoBl9GpQGQkr/99udSZcuUE8L2mjAoGAPRLn
LVuDTL58a3D2sFC3BcLth/nUPSmxwCsutHlLf5ngme7l/RCa9GY0ibeX9t0JrpaV
m+qpCexH18jT/LUu5oa1N3JX0Kye8eUmBqPoj7N30VX06YDRobpI24Yei/19e0p8
ZbI+qpzo1YvUGhkJqo21AMwUMTFCO1cbOL6yvyMCgYAHUNBLhSOaIZpvbmyh5uz5
Va/IIYU5nJcVAan8ExzdVBqeiDqlIDsUt/4xoV2sWOK1lDmL1QYeOOTOHdVcSUyN
ZpvB3b/9RZ1bNQZA1trBBxjY7dXNwZZp0ah/bmO+i4dPXl+bU2mUqdyb1emFwcj0
uNGn7GMQXLxalpCkz4SXRg==
-----END PRIVATE KEY-----
```
处理后：
```language
-----BEGIN PRIVATE KEY-----
MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDCjDQA8SH0X3W++0DOXtUWZdEA4aGWj7bYpf6uoLfOIaDj7IiTx68AvVP3tcS4rWG6pwCn6ng8gba39FvcUEP69UkahcqzIsIxSZPhLLn9NGFvdMzQId5+8xlNIzBxXMpPTsO3HIaAVmP1axRhlasFQ9y7S8PqzublB7eoUklZV5Ffw0OdUDHJLOvPhsjj7Wq+3J7L+5qncjq3HFHFSUhozJOwPymXre7Xh0PYUdEzolje2Z0SkEQxYj3WqZhuX0eQf8Ppe26aDQebOHTpt2uU7dg2xymvqI3a6DrIY20CHj+6Dg/hlX2fEiZyPyXw+3eOKjU7Qgil/gxQIwP4Ls+tAgMBAAECggEAaQOlTpza5z5gIKcfZEZsX5q2JvOkddE9sdRolXrLvMkKP/39+0def9ey65OCjO2KQ2bCQ+Gc5YxfRQzySQpKp7yfqWFu+SNaD6DX4kRyYOtVbQRvSin+ICi5D5pfG9IqooSxwLX1JHF9o4wZhFN17XGkRLWxG55zpE12JbXFQiPBpck6hcMfx+r5wk7t4ret/8P/MDcyrPuUavJemd4D2jRrD7AmOGJDvElioFcOKA+VS8oe/uBdpU8cbYJvct68fHOzG9IW3hdqYV18fhNtWqp9WeuUP+F2UMmOXbAtZ106Zcd+V/jsse2G9KvGzmDA61ZGxzHUjt+JNIpN+V2HQQKBgQDkfYb8vIMc2yV0CM30mAaPIapgpw8brYS8v+azQR/jjsuHFJ1CQJAih79y2gwdjKbDl0XByjj/qiHLTPcu6dkuavdsV9MrlFfVqAXUMNDHrWEn5nMahlq3UZbflBqlavTr0gvEA8Da+ZXcRvWgTP5+g5RFrKHJVOyQ+GzgDggQawKBgQDZ+IDRthf0UHvvZsoUbeb37Wut9jdjRgLJS1X4RtH+NPN23lvtTKJmUNfrFxiOfeVBfCXmGep0ibTqDVo0zBeHSu4BFM3BsICu7xafmLafZxZqHcgWuF9keOCWjKN5fzub5xGqd2yge9hGN2zA2U9qp4mltGzeoZ/0TuLuR59GRwKBgCGga7ZUVANyKQ/rn8vod8am0LlKvMl4/vj8UQp+gh/uSvvFR+ORNuUuDznq5y+OHJjacXS0uzC9LB4MZLBtz/2p1mIGhth6C3cxNDJnQMKyPIMvwi7cKQujoU2kMUu48vSlw/+EAeT4KFrzwoBl9GpQGQkr/99udSZcuUE8L2mjAoGAPRLnLVuDTL58a3D2sFC3BcLth/nUPSmxwCsutHlLf5ngme7l/RCa9GY0ibeX9t0JrpaVm+qpCexH18jT/LUu5oa1N3JX0Kye8eUmBqPoj7N30VX06YDRobpI24Yei/19e0p8ZbI+qpzo1YvUGhkJqo21AMwUMTFCO1cbOL6yvyMCgYAHUNBLhSOaIZpvbmyh5uz5Va/IIYU5nJcVAan8ExzdVBqeiDqlIDsUt/4xoV2sWOK1lDmL1QYeOOTOHdVcSUyNZpvB3b/9RZ1bNQZA1trBBxjY7dXNwZZp0ah/bmO+i4dPXl+bU2mUqdyb1emFwcj0uNGn7GMQXLxalpCkz4SXRg==
-----END PRIVATE KEY-----
```


5. （可选）将pem内容进行 base64 编码后，配置到k8s

echo -n '-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwow0APEh9F91vvtAzl7VFmXRAOGhlo+22KX+rqC3ziGg4+yIk8evAL1T97XEuK1huqcAp+p4PIG2t/Rb3FBD+vVJGoXKsyLCMUmT4Sy5/TRhb3TM0CHefvMZTSMwcVzKT07DtxyGgFZj9WsUYZWrBUPcu0vD6s7m5Qe3qFJJWVeRX8NDnVAxySzrz4bI4+1qvtyey/uap3I6txxRxUlIaMyTsD8pl63u14dD2FHRM6JY3tmdEpBEMWI91qmYbl9HkH/D6Xtumg0Hmzh06bdrlO3YNscpr6iN2ug6yGNtAh4/ug4P4ZV9nxImcj8l8Pt3jio1O0IIpf4MUCMD+C7PrQIDAQAB
-----END PUBLIC KEY-----' |base64


echo -n '-----BEGIN PRIVATE KEY-----
MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDCjDQA8SH0X3W++0DOXtUWZdEA4aGWj7bYpf6uoLfOIaDj7IiTx68AvVP3tcS4rWG6pwCn6ng8gba39FvcUEP69UkahcqzIsIxSZPhLLn9NGFvdMzQId5+8xlNIzBxXMpPTsO3HIaAVmP1axRhlasFQ9y7S8PqzublB7eoUklZV5Ffw0OdUDHJLOvPhsjj7Wq+3J7L+5qncjq3HFHFSUhozJOwPymXre7Xh0PYUdEzolje2Z0SkEQxYj3WqZhuX0eQf8Ppe26aDQebOHTpt2uU7dg2xymvqI3a6DrIY20CHj+6Dg/hlX2fEiZyPyXw+3eOKjU7Qgil/gxQIwP4Ls+tAgMBAAECggEAaQOlTpza5z5gIKcfZEZsX5q2JvOkddE9sdRolXrLvMkKP/39+0def9ey65OCjO2KQ2bCQ+Gc5YxfRQzySQpKp7yfqWFu+SNaD6DX4kRyYOtVbQRvSin+ICi5D5pfG9IqooSxwLX1JHF9o4wZhFN17XGkRLWxG55zpE12JbXFQiPBpck6hcMfx+r5wk7t4ret/8P/MDcyrPuUavJemd4D2jRrD7AmOGJDvElioFcOKA+VS8oe/uBdpU8cbYJvct68fHOzG9IW3hdqYV18fhNtWqp9WeuUP+F2UMmOXbAtZ106Zcd+V/jsse2G9KvGzmDA61ZGxzHUjt+JNIpN+V2HQQKBgQDkfYb8vIMc2yV0CM30mAaPIapgpw8brYS8v+azQR/jjsuHFJ1CQJAih79y2gwdjKbDl0XByjj/qiHLTPcu6dkuavdsV9MrlFfVqAXUMNDHrWEn5nMahlq3UZbflBqlavTr0gvEA8Da+ZXcRvWgTP5+g5RFrKHJVOyQ+GzgDggQawKBgQDZ+IDRthf0UHvvZsoUbeb37Wut9jdjRgLJS1X4RtH+NPN23lvtTKJmUNfrFxiOfeVBfCXmGep0ibTqDVo0zBeHSu4BFM3BsICu7xafmLafZxZqHcgWuF9keOCWjKN5fzub5xGqd2yge9hGN2zA2U9qp4mltGzeoZ/0TuLuR59GRwKBgCGga7ZUVANyKQ/rn8vod8am0LlKvMl4/vj8UQp+gh/uSvvFR+ORNuUuDznq5y+OHJjacXS0uzC9LB4MZLBtz/2p1mIGhth6C3cxNDJnQMKyPIMvwi7cKQujoU2kMUu48vSlw/+EAeT4KFrzwoBl9GpQGQkr/99udSZcuUE8L2mjAoGAPRLnLVuDTL58a3D2sFC3BcLth/nUPSmxwCsutHlLf5ngme7l/RCa9GY0ibeX9t0JrpaVm+qpCexH18jT/LUu5oa1N3JX0Kye8eUmBqPoj7N30VX06YDRobpI24Yei/19e0p8ZbI+qpzo1YvUGhkJqo21AMwUMTFCO1cbOL6yvyMCgYAHUNBLhSOaIZpvbmyh5uz5Va/IIYU5nJcVAan8ExzdVBqeiDqlIDsUt/4xoV2sWOK1lDmL1QYeOOTOHdVcSUyNZpvB3b/9RZ1bNQZA1trBBxjY7dXNwZZp0ah/bmO+i4dPXl+bU2mUqdyb1emFwcj0uNGn7GMQXLxalpCkz4SXRg==
-----END PRIVATE KEY-----' |base64
