-- 10.1.init-message.sql


/*
将 paas.example.com 替换为 paas.学校域名.edu.cn
*/

-- 以下脚本为可选操作

/*
 * 若部署了流程平台、门户的产品
 * 可初始化云平台下的相关菜单数据
 */

use admin_center;

-- message
-- 如果部署，流程平台，请处理


insert into TB_MGT_ROLE (ID, DELETED, CODE, NAME, MEMO, STATUS) 
values ('80', 0, 'message-admin', '消息平台管理员', '', '1');
insert into TB_MGT_ROLE (ID, DELETED, CODE, NAME, MEMO, STATUS) 
values ('81', 0, 'message-opt', '消息平台操作员', '', '1');

commit;


/*
消息服务 message-backstage
名称  路由  图标
消息网关管理  /message-backstage/msgGateWay su-icon-xiaoxiwangguan
短信模板管理  /message-backstage/SMSTemplateManage  su-icon-mobanguanli
消息类别管理  /message-backstage/msgTypes su-icon-xiaoxileibie
消息任务监控  /message-backstage/msgTaskMonitor su-icon-renwujiankong
消息日志审计  /message-backstage/msgLogAudit  su-icon-details
应用管理  /message-backstage/msgSoftManage  su-icon-sort
敏感词管理 /message-backstage/SensitiveWords su-icon-lock-w
设置  /message-backstage/msgSendCondition su-icon-print
*/

update TB_MGT_PERMISSION
  set LFT = LFT+18
where LFT>=92
;

update TB_MGT_PERMISSION
  set RGT = RGT+18
where RGT>=92
;


insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, ICON, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('80000', 0, 'message-backstage', '消息服务', '1', '2', '', '/', '1', '1', 80000, 1, 92, 109);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, ICON, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('80100', 0, 'formflow', '消息网关管理', '1', '2', 'su-icon-xiaoxiwangguan', '/message-backstage/msgGateWay', '1', '80000', 80100, 2, 93, 94);
insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, ICON, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('80200', 0, 'workbench', '短信模板管理', '1', '2', 'su-icon-mobanguanli', '/message-backstage/SMSTemplateManage', '1', '80000', 80200, 2, 95, 96);
insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, ICON, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('80300', 0, 'instanceManage', '消息类别管理', '1', '2', 'su-icon-xiaoxileibie', '/message-backstage/msgTypes', '1', '80000', 80300, 2, 97, 98);
insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, ICON, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('80400', 0, 'agent', '消息任务监控', '1', '2', 'su-icon-renwujiankong', '/message-backstage/msgTaskMonitor', '1', '80000', 80400, 2, 99, 100);
insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, ICON, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('80500', 0, 'agent', '消息日志审计', '1', '2', 'su-icon-details', '/message-backstage/msgLogAudit', '1', '80000', 80500, 2, 101, 102);

insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, ICON, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('80600', 0, 'agent', '应用管理', '1', '2', 'su-icon-sort', '/message-backstage/msgSoftManage', '1', '80000', 80600, 2, 103, 104);
insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, ICON, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('80700', 0, 'agent', '敏感词管理', '1', '2', 'su-icon-lock-w', '/message-backstage/SensitiveWords', '1', '80000', 80700, 2, 105, 106);
insert into TB_MGT_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, ICON, URL, APPLICATION_ID, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('80800', 0, 'agent', '设置', '1', '2', 'su-icon-print', '/message-backstage/msgSendCondition', '1', '80000', 80800, 2, 107, 108);

commit;


insert into TB_MGT_ROLE_PERMISSION (ID, DELETED, ROLE_ID, PERMISSION_ID) 

select CONCAT('1_', ID) as ID, 0 as DELETED, '1' as ROLE_ID, ID as PERMISSION_ID 
from TB_MGT_PERMISSION
where (ID like '8____' or ID='1')
  and CONCAT('1_', ID) not in (select ID from TB_MGT_ROLE_PERMISSION)
;

insert into TB_MGT_ROLE_PERMISSION (ID, DELETED, ROLE_ID, PERMISSION_ID) 

select CONCAT('80_', ID) as ID, 0 as DELETED, '50' as ROLE_ID, ID as PERMISSION_ID 
from TB_MGT_PERMISSION
where (ID like '8____' or ID='1')
  and CONCAT('80_', ID) not in (select ID from TB_MGT_ROLE_PERMISSION)
;

commit;


-- 更新 admin-platform 下菜单的访问域

update TB_MGT_PERMISSION
set 
  ORIGIN='http://admin-platform.paas.example.com'
where LFT >= 92
  and RGT <= 109
;

commit;
