-- 10.0.init.sql


use cas_server;


INSERT INTO `TB_SERVICE` (`ID`, `COMPANY_ID`, `DELETED`, `ADD_ACCOUNT`, `ADD_TIME`, 
  `NAME`, `DESCRIPTION`, `INFORMATION_URL`, `LOGOUT_URL`, 
  `RESPONSE_TYPE`, `LOGOUT_TYPE`, 
  `EVALUATION_ORDER`, `FRIENDLY_NAME`, `REGISTERED_SERVICE_ID`, `SERVICE_ID`, 
  `ENABLED`, `SSO_ENABLED`, `REQUIRE_ALL_ATTRIBUTES`, 
  `APPLICATION_ID`, `EXTERNAL_ID`)
VALUES ('22', '1', 0, 'admin', '2020-07-01 00:00:00',
  '安全中心', '安全中心', 'https://security-center.paas.example.com', 'https://security-center.paas.example.com/logout', 
  'REDIRECT', 'FRONT_CHANNEL', 
  22, '安全中心', 22, 'https://security-center.paas.example.com/(.*)', 
  1, 1, 1, 
  '22', '22');

commit;


-- 修改根域名
update TB_SERVICE 
set 
  INFORMATION_URL='http://security-center.paas.example.com', 
  LOGOUT_URL='http://security-center.paas.example.com/logout', 
  SERVICE_ID='http://security-center.paas.example.com/(.*)', 
  ID_TOKEN_ENABLED=1,
  JWT_AS_SERVICE_TICKET=1,
  APPLICATION_DOMAIN='security-center.paas.example.com'
where ID='22';  -- todo, modify

commit;




use user;

-- **配置 身份对应的帐号 须自动关联的 用户组**

/*

IDENTITY_TYPE

1     admin         系统用户

T01   T01           教职工

S01   S01           本科生
S02   S02           研究生
S03   S03           非学历生

P01   P01           聘用人员
P02   P02           外聘教师
P99   P99           在职/企业博士后


GROUP

11  teacher       教职工用户组
12  student       本科生用户组
13  graduate      研究生用户组
14  fellow        校友用户组

16  admin         管理人员用户组
17  retire        退休用户组

010883e0ac5e11eaaaee297ae5eef932    bsh           在职/企业博士后

23f87450ac5e11eaaaee297ae5eef932    wpjs          外聘教师
f1e42c20ac5d11eaaaee297ae5eef932    pyry          聘用人员

ffa610e0ac6111eaaaee297ae5eef932    fxls          非学历生用户组

*/


insert into TB_B_IDENTITY_TYPE_GROUP_INITIAL (ID, DELETED, ADD_ACCOUNT, IDENTITY_TYPE_ID, GROUP_ID)
values ('1', 0, 'init', 'T01', '11');

insert into TB_B_IDENTITY_TYPE_GROUP_INITIAL (ID, DELETED, ADD_ACCOUNT, IDENTITY_TYPE_ID, GROUP_ID)
values ('2', 0, 'init', 'S01', '12');

insert into TB_B_IDENTITY_TYPE_GROUP_INITIAL (ID, DELETED, ADD_ACCOUNT, IDENTITY_TYPE_ID, GROUP_ID)
values ('3', 0, 'init', 'S02', '13');

insert into TB_B_IDENTITY_TYPE_GROUP_INITIAL (ID, DELETED, ADD_ACCOUNT, IDENTITY_TYPE_ID, GROUP_ID)
values ('4', 0, 'init', 'S03', 'ffa610e0ac6111eaaaee297ae5eef932');

insert into TB_B_IDENTITY_TYPE_GROUP_INITIAL (ID, DELETED, ADD_ACCOUNT, IDENTITY_TYPE_ID, GROUP_ID)
values ('5', 0, 'init', 'P01', 'f1e42c20ac5d11eaaaee297ae5eef932');

insert into TB_B_IDENTITY_TYPE_GROUP_INITIAL (ID, DELETED, ADD_ACCOUNT, IDENTITY_TYPE_ID, GROUP_ID)
values ('6', 0, 'init', 'P02', '23f87450ac5e11eaaaee297ae5eef932');

insert into TB_B_IDENTITY_TYPE_GROUP_INITIAL (ID, DELETED, ADD_ACCOUNT, IDENTITY_TYPE_ID, GROUP_ID)
values ('7', 0, 'init', 'P99', '010883e0ac5e11eaaaee297ae5eef932');

commit;

